"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveRefAssertion
 * 
 */
function toHaveRef(enzymeWrapper, refName) {
  if (typeof enzymeWrapper.ref !== 'function') {
    throw new Error('EnzymeMatchers::toHaveRef can not be called on a shallow wrapper');
  }

  const node = enzymeWrapper.ref(refName);
  const pass = !!node;
  return {
    pass,
    message: `Expected to find a ref named "${refName}" on <${(0, _name.default)(enzymeWrapper)}>, but didn't.`,
    negatedMessage: `Expected not to find a ref named "${refName}" on <${(0, _name.default)(enzymeWrapper)}>, but did.`,
    contextualInformation: {}
  };
}

var _default = (0, _single.default)(toHaveRef);

exports.default = _default;
module.exports = exports.default;