"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _reduceAssertionObject = _interopRequireDefault(require("../utils/reduceAssertionObject"));

var _stringify = _interopRequireDefault(require("../utils/stringify"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveStateAssertion
 * 
 */
function toHaveState(enzymeWrapper, stateKey, stateValue) {
  const state = enzymeWrapper.state();
  const wrapperName = (0, _name.default)(enzymeWrapper); // The API allows checking if a component has a value for a given key by dropping the third
  // argument.

  if (stateValue === undefined && arguments.length === 2 && typeof stateKey !== 'object' && Array.isArray(stateKey) === false) {
    return {
      pass: state.hasOwnProperty(stateKey),
      message: `Expected the state for <${wrapperName}> to contain the key "${stateKey}", but it did not.`,
      negatedMessage: `Expected the state for <${wrapperName}> to not contain the key "${stateKey}", but it did.`,
      contextualInformation: {
        actual: `Actual state: ${(0, _stringify.default)({
          [stateKey]: state[stateKey]
        })}`
      }
    };
  }

  const results = _reduceAssertionObject.default.call(this, state, stateKey, stateValue);

  const contextualInformation = {
    actual: `Actual state: ${(0, _stringify.default)(results.actual)}`,
    expected: `Expected state: ${(0, _stringify.default)(results.expected)}`
  }; // error if some state doesn't exist

  if (results.missingKeys.length) {
    const missingKeys = results.missingKeys.join(', ');

    const _key_ = results.missingKeys.length === 1 ? 'key' : 'keys';

    return {
      pass: false,
      message: `Expected the state for <${wrapperName}> to contain the ${_key_} "${missingKeys}", but it did not.`,
      negatedMessage: `Expected the state for <${wrapperName}> to not contain the ${_key_} "${missingKeys}", but it did.`,
      contextualInformation
    };
  }

  const unmatchedKeys = results.unmatchedKeys.join(', ');

  const _key_ = results.unmatchedKeys.length === 1 ? 'key' : 'keys';

  return {
    pass: results.pass,
    message: `Expected the state for <${wrapperName}> to match for ${_key_} "${unmatchedKeys}", but it did not.`,
    negatedMessage: `Expected the state for <${wrapperName}> to not match for ${_key_} "${unmatchedKeys}", but it did.`,
    contextualInformation
  };
}

var _default = (0, _single.default)(toHaveState);

exports.default = _default;
module.exports = exports.default;