"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _html = _interopRequireDefault(require("../utils/html"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveTextAssertion
 * 
 */
function toHaveText(enzymeWrapper, text) {
  const actualText = enzymeWrapper.text();
  const wrapperName = `<${(0, _name.default)(enzymeWrapper)}>`;
  const wrapperHtml = (0, _html.default)(enzymeWrapper);
  let pass;

  if (text === undefined) {
    pass = actualText.length > 0;
    return {
      pass,
      message: `Expected ${wrapperName} node to have text, but it did not.`,
      negatedMessage: `Expected ${wrapperName} node not to have text, but it did`,
      contextualInformation: {
        actual: `Actual HTML: "${wrapperHtml}"`
      }
    };
  }

  pass = actualText === text;
  return {
    pass,
    message: `Expected ${wrapperName} components text to match (using ===), but it did not.`,
    negatedMessage: `Expected ${wrapperName} components text not to match (using ===), but it did.`,
    contextualInformation: {
      actual: `Actual HTML: "${actualText}"`,
      expected: `Expected HTML: "${text}"`
    }
  };
}

var _default = (0, _single.default)(toHaveText);

exports.default = _default;
module.exports = exports.default;