"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _html = _interopRequireDefault(require("../utils/html"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveValueAssertion
 * 
 */
function toHaveValue(enzymeWrapper, expectedValue) {
  let pass = false;
  const props = enzymeWrapper.props();
  const wrapperName = `<${(0, _name.default)(enzymeWrapper)}>`;
  const wrapperHtml = (0, _html.default)(enzymeWrapper); // set to the default checked

  if (props.hasOwnProperty('defaultValue')) {
    pass = props.defaultValue === expectedValue;
  } // if it has the `value` property, CHECK that


  if (props.hasOwnProperty('value')) {
    pass = props.value === expectedValue;
  }

  return {
    pass,
    message: `Expected ${wrapperName} component to have the value of "${expectedValue}" (using ===), but it didn't.`,
    negatedMessage: `Expected ${wrapperName} component not to have the value of "${expectedValue}" (using ===), but it did.`,
    contextualInformation: {
      actual: wrapperHtml
    }
  };
}

var _default = (0, _single.default)(toHaveValue);

exports.default = _default;
module.exports = exports.default;