"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toIncludeTextAssertion
 * 
 */
function toIncludeText(enzymeWrapper, text) {
  const actualText = enzymeWrapper.text();

  if (text === undefined) {
    const message = `Expected ".toIncludeText(null)" to be given some text.
      If you are trying to assert this component has _some_ text, use the ".toHaveText()" matcher`;
    return {
      pass: false,
      message,
      negatedMessage: message,
      contextualInformation: {}
    };
  }

  const pass = actualText.includes(text);
  const wrapperName = `<${(0, _name.default)(enzymeWrapper)}>`;
  return {
    pass,
    message: `Expected ${wrapperName} to contain "${text}" but it did not.`,
    negatedMessage: `Expected ${wrapperName} not to contain "${text}" but it did.`,
    contextualInformation: {
      expected: `Expected HTML: "${text}"`,
      actual: `Actual HTML: "${actualText}"`
    }
  };
}

var _default = (0, _single.default)(toIncludeText);

exports.default = _default;
module.exports = exports.default;