"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = deprecate;

var _colors = _interopRequireDefault(require("./colors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function deprecate(matcherFn, message) {
  let shouldWarn = true;
  return function deprecateWrapper(enzymeWrapper, ...args) {
    if (shouldWarn) {
      // eslint-disable-next-line no-console
      console.warn(_colors.default.yellow(message));
      shouldWarn = false;
    }

    return matcherFn.call(this, enzymeWrapper, ...args);
  };
}

module.exports = exports.default;