"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getDisplayName;

function getDisplayName(Component) {
  if (typeof Component === 'string') {
    return Component;
  }

  if (!Component) {
    // Should never actually reach here, Function cannot be falsy.
    return 'undefined';
  }

  return Component.displayName || Component.name || 'Component';
}

module.exports = exports.default;