"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = stringify;

var _circularJsonEs = _interopRequireDefault(require("circular-json-es6"));

var _colors = _interopRequireDefault(require("./colors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function stringifySingle(key, value) {
  let stringifyingValue = value;
  let skipCircularCheck = false;

  if (Array.isArray(value)) {
    const values = value.map(v => stringifySingle('', v)[1]); // Skip circular check because we have already safely dealt with it above

    skipCircularCheck = true;
    let joined = values.join(' ');

    let initialBracket = _colors.default.gray('[');

    const endingBracket = _colors.default.gray(']');

    if (joined.length > 20) {
      const pad = '\n  ';
      joined = `${values.join(pad)}\n`;
      initialBracket += pad;
    }

    stringifyingValue = _colors.default.gray(`${initialBracket}${joined}${endingBracket}`);
  } else if (value === null) {
    stringifyingValue = _colors.default.gray(value);
  } else if (typeof value === 'object') {
    stringifyingValue = _colors.default.gray(_circularJsonEs.default.stringify(value));
  } else if (typeof value === 'string') {
    stringifyingValue = _colors.default.gray(`"${value}"`);
  } else if (typeof value === 'number') {
    stringifyingValue = _colors.default.blue(value);
  } else if (value) {
    stringifyingValue = _colors.default.green(value);
  } else if (!value) {
    stringifyingValue = _colors.default.red(value);
  }

  try {
    // circular if you cant stringify
    if (!skipCircularCheck) {
      JSON.stringify({
        [key]: value
      });
    }

    return [key, stringifyingValue];
  } catch (e) {
    return [key, _colors.default.gray('[Circular]')];
  }
}

function color([key, value]) {
  return `${_colors.default.yellow(key)}${_colors.default.gray(':')} ${_colors.default.yellow(value)}`;
}

function stringify(object) {
  const keys = Object.keys(object);
  return keys.map(key => color(stringifySingle(key, object[key]))).join('\n');
}

module.exports = exports.default;