"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _html = _interopRequireDefault(require("../utils/html"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toBeEmptyRenderAssertion
 * 
 */
function toBeEmptyRender(enzymeWrapper) {
  const pass = enzymeWrapper.isEmptyRender();
  return {
    pass,
    message: `Expected <${(0, _name.default)(enzymeWrapper)}> to be empty render (false or null), but it was not`,
    negatedMessage: `Expected <${(0, _name.default)(enzymeWrapper)}> not to be empty render (false or null), but it was`,
    contextualInformation: {
      actual: `Found Nodes HTML output: ${(0, _html.default)(enzymeWrapper)}`
    }
  };
}

var _default = (0, _single.default)(toBeEmptyRender);

exports.default = _default;
module.exports = exports.default;