"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toExist;

var _html = _interopRequireDefault(require("../utils/html"));

var _name = _interopRequireDefault(require("../utils/name"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toBePresentAssertion
 * 
 */
function toExist(enzymeWrapper) {
  const pass = enzymeWrapper.exists();
  const contextualInformation = {};

  if (enzymeWrapper.getElements().length) {
    contextualInformation.actual = `Found Nodes: ${(0, _html.default)(enzymeWrapper)}`;
  }

  const nodeName = (0, _name.default)(enzymeWrapper);
  return {
    pass,
    message: `Expected "${nodeName}" to exist.`,
    negatedMessage: `Expected "${nodeName}" not to exist. Instead found ${enzymeWrapper.getElements().length} nodes.`,
    contextualInformation
  };
}

module.exports = exports.default;