"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toHaveClassName;

var _name = _interopRequireDefault(require("../utils/name"));

var _html = _interopRequireDefault(require("../utils/html"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveClassNameAssertion
 * 
 */
function toHaveClassName(enzymeWrapper, className) {
  let normalizedClassName = className.split(' ').join('.');
  let actualClassName = '(none)';
  let pass = false;

  if (normalizedClassName[0] !== '.') {
    normalizedClassName = `.${normalizedClassName}`;
  } // handle different lengths of enzymeWrappers


  switch (enzymeWrapper.getElements().length) {
    case 0:
      break;
    // this will and should fail the test

    case 1:
      pass = enzymeWrapper.is(normalizedClassName);
      actualClassName = enzymeWrapper.prop('className');
      break;

    default:
      let allMatch = true;
      enzymeWrapper.forEach(node => {
        if (!node.is(normalizedClassName)) {
          allMatch = false;
        }

        actualClassName = node.prop('className');
      });
      pass = allMatch;
  }

  return {
    pass,
    message: `Expected <${(0, _name.default)(enzymeWrapper)}> to have className of "${normalizedClassName}" but instead found "${actualClassName}"`,
    // eslint-disable-line max-len
    negatedMessage: `Expected <${(0, _name.default)(enzymeWrapper)}> not to contain "${normalizedClassName}" in its className`,
    contextualInformation: {
      actual: `Found node output: ${(0, _html.default)(enzymeWrapper)}`
    }
  };
}

module.exports = exports.default;