"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveHTMLAssertion
 * 
 */
function toHaveHTML(enzymeWrapper, html) {
  const wrapperHTML = enzymeWrapper.html(); // normalize quotes

  const useSingleQuotes = html.search("'") !== -1;
  const actualHTML = wrapperHTML.replace(/("|')/g, useSingleQuotes ? "'" : '"');
  const expectedHTML = html.replace(/("|')/g, useSingleQuotes ? "'" : '"').replace(/>[\n\t ]+</g, '><');
  const pass = actualHTML === expectedHTML;
  return {
    pass,
    message: `Expected <${(0, _name.default)(enzymeWrapper)}> html to match the expected, but it didn't.`,
    negatedMessage: `Expected <${(0, _name.default)(enzymeWrapper)}> html not to match the expected, but it did.`,
    contextualInformation: {
      actual: `Actual HTML: ${actualHTML}`,
      expected: `Expected HTML: ${expectedHTML}`
    }
  };
}

var _default = (0, _single.default)(toHaveHTML);

exports.default = _default;
module.exports = exports.default;