"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _reduceAssertionObject = _interopRequireDefault(require("../utils/reduceAssertionObject"));

var _stringify = _interopRequireDefault(require("../utils/stringify"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHavePropAssertion
 * 
 */
function toHaveProp(enzymeWrapper, propKey, propValue) {
  const props = enzymeWrapper.props();
  const wrapperName = (0, _name.default)(enzymeWrapper); // The API allows to check if a component has a prop in general by dropping the third
  // argument.

  if (propValue === undefined && arguments.length === 2 && typeof propKey !== 'object' && Array.isArray(propKey) === false) {
    return {
      pass: props.hasOwnProperty(propKey),
      message: `Expected <${wrapperName}> to have received the prop "${propKey}", but it did not.`,
      negatedMessage: `Expected <${wrapperName}> to not have received the prop "${propKey}", but it did.`,
      contextualInformation: {
        actual: `Actual props: ${(0, _stringify.default)({
          [propKey]: props[propKey]
        })}`
      }
    };
  }

  const results = _reduceAssertionObject.default.call(this, props, propKey, propValue);

  const unmatchedKeys = results.unmatchedKeys.join(', ');
  const contextualInformation = {
    actual: `Actual props: ${(0, _stringify.default)(results.actual)}`,
    expected: `Expected props: ${(0, _stringify.default)(results.expected)}`
  }; // error if some prop doesn't exist

  if (results.missingKeys.length) {
    const missingKeys = results.missingKeys.join(', ');

    const _prop_ = results.missingKeys.length === 1 ? 'prop' : 'props';

    return {
      pass: false,
      message: `Expected <${wrapperName}}> to have ${_prop_} "${missingKeys}", but it did not.`,
      negatedMessage: `Expected <${wrapperName}> to not have ${_prop_} "${missingKeys}", but it did.`,
      contextualInformation
    };
  }

  const _prop_ = results.unmatchedKeys.length === 1 ? 'prop' : 'props';

  return {
    pass: results.pass,
    message: `Expected <${wrapperName}> to match for ${_prop_} "${unmatchedKeys}", but it did not.`,
    negatedMessage: `Expected <${wrapperName}> to not match for ${_prop_} "${unmatchedKeys}", but it did.`,
    contextualInformation
  };
}

var _default = (0, _single.default)(toHaveProp);

exports.default = _default;
module.exports = exports.default;