"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _enzyme = require("enzyme");

var _isShallowWrapper = _interopRequireDefault(require("../utils/isShallowWrapper"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toMatchElementAssertion
 * 
 */
function toMatchElement(actualEnzymeWrapper, reactInstance, options = {
  ignoreProps: true
}) {
  let expectedWrapper;

  if (!(0, _isShallowWrapper.default)(actualEnzymeWrapper)) {
    expectedWrapper = (0, _enzyme.mount)(reactInstance);
  } else {
    expectedWrapper = (0, _enzyme.shallow)(reactInstance);
  }

  const actual = actualEnzymeWrapper.debug({
    verbose: true,
    ...options
  });
  const expected = expectedWrapper.debug({
    verbose: true,
    ...options
  });
  const pass = actual === expected;
  return {
    pass,
    message: 'Expected actual value to match the expected value.',
    negatedMessage: 'Did not expect actual value to match the expected value.',
    contextualInformation: {
      actual: `Actual:\n ${actual}`,
      expected: `Expected:\n ${expected}`
    }
  };
}

var _default = (0, _single.default)(toMatchElement);

exports.default = _default;
module.exports = exports.default;