"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _toBeChecked = _interopRequireDefault(require("./assertions/toBeChecked"));

var _toBeDisabled = _interopRequireDefault(require("./assertions/toBeDisabled"));

var _toBeEmptyRender = _interopRequireDefault(require("./assertions/toBeEmptyRender"));

var _toContainMatchingElement = _interopRequireDefault(require("./assertions/toContainMatchingElement"));

var _toContainMatchingElements = _interopRequireDefault(require("./assertions/toContainMatchingElements"));

var _toContainExactlyOneMatchingElement = _interopRequireDefault(require("./assertions/toContainExactlyOneMatchingElement"));

var _toContainReact = _interopRequireDefault(require("./assertions/toContainReact"));

var _toExist = _interopRequireDefault(require("./assertions/toExist"));

var _toHaveClassName = _interopRequireDefault(require("./assertions/toHaveClassName"));

var _toHaveDisplayName = _interopRequireDefault(require("./assertions/toHaveDisplayName"));

var _toHaveHTML = _interopRequireDefault(require("./assertions/toHaveHTML"));

var _toHaveProp = _interopRequireDefault(require("./assertions/toHaveProp"));

var _toHaveRef = _interopRequireDefault(require("./assertions/toHaveRef"));

var _toHaveState = _interopRequireDefault(require("./assertions/toHaveState"));

var _toHaveStyle = _interopRequireDefault(require("./assertions/toHaveStyle"));

var _toHaveTagName = _interopRequireDefault(require("./assertions/toHaveTagName"));

var _toHaveText = _interopRequireDefault(require("./assertions/toHaveText"));

var _toIncludeText = _interopRequireDefault(require("./assertions/toIncludeText"));

var _toHaveValue = _interopRequireDefault(require("./assertions/toHaveValue"));

var _toMatchSelector = _interopRequireDefault(require("./assertions/toMatchSelector"));

var _toMatchElement = _interopRequireDefault(require("./assertions/toMatchElement"));

var _protectAssertion = _interopRequireDefault(require("./utils/protectAssertion"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule enzyme-matchrs
 * 
 */
const assertions = {
  toBeChecked: _toBeChecked.default,
  toBeDisabled: _toBeDisabled.default,
  toBeEmptyRender: _toBeEmptyRender.default,
  toContainMatchingElement: _toContainMatchingElement.default,
  toContainMatchingElements: _toContainMatchingElements.default,
  toContainExactlyOneMatchingElement: _toContainExactlyOneMatchingElement.default,
  toContainReact: _toContainReact.default,
  toExist: _toExist.default,
  toHaveClassName: _toHaveClassName.default,
  toHaveDisplayName: _toHaveDisplayName.default,
  toHaveHTML: _toHaveHTML.default,
  toHaveProp: _toHaveProp.default,
  toHaveRef: _toHaveRef.default,
  toHaveState: _toHaveState.default,
  toHaveStyle: _toHaveStyle.default,
  toHaveTagName: _toHaveTagName.default,
  toHaveText: _toHaveText.default,
  toIncludeText: _toIncludeText.default,
  toHaveValue: _toHaveValue.default,
  toMatchSelector: _toMatchSelector.default,
  toMatchElement: _toMatchElement.default
}; // Protect all assertions from being called with not-enzyme-wrappers.

Object.keys(assertions).forEach(key => {
  assertions[key] = (0, _protectAssertion.default)(assertions[key]);
});
var _default = assertions;
exports.default = _default;
module.exports = exports.default;