"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = printHTMLForWrapper;

var _instance = _interopRequireDefault(require("./instance"));

var _isShallowWrapper = _interopRequireDefault(require("./isShallowWrapper"));

var _getConsoleObject = _interopRequireDefault(require("./getConsoleObject"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const consoleObject = (0, _getConsoleObject.default)();

const noop = () => {};

function mapWrappersHTML(wrapper) {
  return wrapper.getElements().map(node => {
    const inst = (0, _instance.default)(node);
    const type = node.type || inst._tag;
    const {
      error
    } = consoleObject;
    consoleObject.error = noop;
    const {
      children,
      ...props
    } = node.props ? node.props : inst._currentElement.props;
    consoleObject.error = error;
    const transformedProps = Object.keys(props).map(key => {
      try {
        return `${key}="${props[key].toString()}"`;
      } catch (e) {
        return `${key}="[object Object]"`;
      }
    });
    let stringifiedNode = `<${type} ${transformedProps.join(' ')}`;

    if (children) {
      stringifiedNode += `>[..children..]</${node.type}`;
    } else {
      stringifiedNode += '/>';
    }

    return stringifiedNode;
  });
}

function printHTMLForWrapper(wrapper) {
  switch (wrapper.getElements().length) {
    case 0:
      {
        return '[empty set]';
      }

    case 1:
      {
        if ((0, _isShallowWrapper.default)(wrapper)) {
          // This is used to clean up in any awkward spacing in the debug output.
          // <div>  <Foo /></div> => <div><Foo /></div>
          return wrapper.debug().replace(/\n(\s*)/g, '');
        }

        return wrapper.html();
      }

    default:
      {
        const nodes = mapWrappersHTML(wrapper).reduce((acc, curr, index) => `${acc}${index}: ${curr}\n`, '');
        return `Multiple nodes found:\n${nodes}`;
      }
  }
}

module.exports = exports.default;