"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/**
 * @function protectAssertion
 *
 * This should wrap every assertion this library outputs.
 * It is intended to help with developers to understand errors
 * when an enzyme-matchers assertion is used with a non-enzyme object.
 *
 * 
 */
function heuristicCheck(arg) {
  try {
    const shouldBeEmptyEnzyme = arg.find('asjdfsaf');
    return shouldBeEmptyEnzyme.length === 0;
  } catch (e) {
    return false;
  }
}

const ERROR_MESSAGE = assertion => `The test assertion ${assertion.name} is part of the enzyme-matcher suite.
It appears you tried calling this matcher with a non-enzyme object.
This assertion must be called against a shallow, mount, or render-ed react component.
`;

const protectAssertion = assertion => function assertionWrapper(enzymeWrapper, ...args) {
  if (heuristicCheck(enzymeWrapper) === false) {
    throw new Error(ERROR_MESSAGE(assertion));
  } // Using `.call` to make sure we bind the runtime environment into the Matcher
  // so we can use asymmetric equalities.


  return assertion.call(this, enzymeWrapper, ...args);
};

var _default = protectAssertion;
exports.default = _default;
module.exports = exports.default;