import type { EtaConfig } from './config';
export declare function hasOwnProp(obj: object, prop: string): boolean;
export declare function copyProps<T>(toObj: T, fromObj: T): T;
/**
 * Takes a string within a template and trims it, based on the preceding tag's whitespace control and `config.autoTrim`
 */
declare function trimWS(str: string, config: EtaConfig, wsLeft: string | false, wsRight?: string | false): string;
/**
 * XML-escapes an input value after converting it to a string
 *
 * @param str - Input value (usually a string)
 * @returns XML-escaped string
 */
declare function XMLEscape(str: any): string;
export { trimWS, XMLEscape };
//# sourceMappingURL=utils.d.ts.map