"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bnToRlp = exports.bnToHex = void 0;
var bytes_1 = require("./bytes");
/**
 * Convert BN to 0x-prefixed hex string.
 */
function bnToHex(value) {
    return "0x" + value.toString(16);
}
exports.bnToHex = bnToHex;
/**
 * Convert value from BN to RLP (unpadded buffer)
 * @param value value to convert
 */
function bnToRlp(value) {
    // Using `bn.toArrayLike(Buffer)` instead of `bn.toBuffer()`
    // for compatibility with browserify and similar tools
    return bytes_1.unpadBuffer(value.toArrayLike(Buffer));
}
exports.bnToRlp = bnToRlp;
//# sourceMappingURL=types.js.map