/// <reference types="node" />
import * as BN from 'bn.js';
import { Address } from './address';
export declare type BNLike = BN | string | number;
export declare type BufferLike = Buffer | Uint8Array | number[] | number | BN | TransformableToBuffer | PrefixedHexString;
export declare type PrefixedHexString = string;
/**
 * A type that represents an Address-like value.
 * To convert to address, use `new Address(toBuffer(value))`
 */
export declare type AddressLike = Address | Buffer | string;
export interface TransformableToArray {
    toArray(): Uint8Array;
    toBuffer?(): Buffer;
}
export interface TransformableToBuffer {
    toBuffer(): Buffer;
    toArray?(): Uint8Array;
}
/**
 * Convert BN to 0x-prefixed hex string.
 */
export declare function bnToHex(value: BN): PrefixedHexString;
/**
 * Convert value from BN to RLP (unpadded buffer)
 * @param value value to convert
 */
export declare function bnToRlp(value: BN): Buffer;
