"use strict";

var _enzymeMatchers = _interopRequireDefault(require("enzyme-matchers"));

var _serializer = _interopRequireDefault(require("enzyme-to-json/serializer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable global-require */

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule setupFilesAfterEnv
 * 
 */
if (global.bootstrapEnzymeEnvironment) {
  const {
    exposeGlobals
  } = require('jest-environment-enzyme/lib/setup');

  exposeGlobals();
} // add the snapshot serializer for Enzyme wrappers


expect.addSnapshotSerializer(_serializer.default); // add methods!

const matchers = {};
Object.keys(_enzymeMatchers.default).forEach(matcherKey => {
  const matcher = {
    [matcherKey](wrapper, ...args) {
      const result = _enzymeMatchers.default[matcherKey].call(this, wrapper, ...args);

      let message = this.isNot ? result.negatedMessage : result.message;

      if (result.contextualInformation.expected) {
        message += `\n${this.utils.RECEIVED_COLOR(result.contextualInformation.expected)}`;
      }

      if (result.contextualInformation.actual) {
        message += `\n${this.utils.EXPECTED_COLOR(result.contextualInformation.actual)}`;
      }

      return { ...result,
        message: () => message
      };
    }

  }[matcherKey];
  matchers[matcherKey] = matcher;
});
expect.extend(matchers);