var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import LRUCache from './LRUCache';

// A cache for frequently used country-specific regular expressions. Set to 32 to cover ~2-3
// countries being used for the same doc with ~10 patterns for each country. Some pages will have
// a lot more countries in use, but typically fewer numbers for each so expanding the cache for
// that use-case won't have a lot of benefit.

var RegExpCache = function () {
	function RegExpCache(size) {
		_classCallCheck(this, RegExpCache);

		this.cache = new LRUCache(size);
	}

	_createClass(RegExpCache, [{
		key: 'getPatternForRegExp',
		value: function getPatternForRegExp(pattern) {
			var regExp = this.cache.get(pattern);
			if (!regExp) {
				regExp = new RegExp('^' + pattern);
				this.cache.put(pattern, regExp);
			}
			return regExp;
		}
	}]);

	return RegExpCache;
}();

export default RegExpCache;
//# sourceMappingURL=RegExpCache.js.map