var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

import _formatNumber from './format_';
import parse from './parse_';

export default function formatNumber() {
	var _normalizeArguments = normalizeArguments(arguments),
	    input = _normalizeArguments.input,
	    format = _normalizeArguments.format,
	    options = _normalizeArguments.options,
	    metadata = _normalizeArguments.metadata;

	return _formatNumber(input, format, options, metadata);
}

// Sort out arguments
function normalizeArguments(args) {
	var _Array$prototype$slic = Array.prototype.slice.call(args),
	    _Array$prototype$slic2 = _slicedToArray(_Array$prototype$slic, 5),
	    arg_1 = _Array$prototype$slic2[0],
	    arg_2 = _Array$prototype$slic2[1],
	    arg_3 = _Array$prototype$slic2[2],
	    arg_4 = _Array$prototype$slic2[3],
	    arg_5 = _Array$prototype$slic2[4];

	var input = void 0;
	var format = void 0;
	var options = void 0;
	var metadata = void 0;

	// Sort out arguments.

	// If the phone number is passed as a string.
	// `format('8005553535', ...)`.
	if (typeof arg_1 === 'string') {
		// If country code is supplied.
		// `format('8005553535', 'RU', 'NATIONAL', [options], metadata)`.
		if (typeof arg_3 === 'string') {
			format = arg_3;

			if (arg_5) {
				options = arg_4;
				metadata = arg_5;
			} else {
				metadata = arg_4;
			}

			input = parse(arg_1, { defaultCountry: arg_2, extended: true }, metadata);
		}
		// Just an international phone number is supplied
		// `format('+78005553535', 'NATIONAL', [options], metadata)`.
		else {
				if (typeof arg_2 !== 'string') {
					throw new Error('`format` argument not passed to `formatNumber(number, format)`');
				}

				format = arg_2;

				if (arg_4) {
					options = arg_3;
					metadata = arg_4;
				} else {
					metadata = arg_3;
				}

				input = parse(arg_1, { extended: true }, metadata);
			}
	}
	// If the phone number is passed as a parsed number object.
	// `format({ phone: '8005553535', country: 'RU' }, 'NATIONAL', [options], metadata)`.
	else if (is_object(arg_1)) {
			input = arg_1;
			format = arg_2;

			if (arg_4) {
				options = arg_3;
				metadata = arg_4;
			} else {
				metadata = arg_3;
			}
		} else throw new TypeError('A phone number must either be a string or an object of shape { phone, [country] }.');

	// Legacy lowercase formats.
	if (format === 'International') {
		format = 'INTERNATIONAL';
	} else if (format === 'National') {
		format = 'NATIONAL';
	}

	return {
		input: input,
		format: format,
		options: options,
		metadata: metadata
	};
}

// Babel transforms `typeof` into some "branches"
// so istanbul will show this as "branch not covered".
/* istanbul ignore next */
var is_object = function is_object(_) {
	return (typeof _ === 'undefined' ? 'undefined' : _typeof(_)) === 'object';
};
//# sourceMappingURL=format.js.map