"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.glGet = glGet;
exports.glKey = glKey;
exports.glKeyType = glKeyType;
Object.defineProperty(exports, "GL", {
  enumerable: true,
  get: function get() {
    return _constants.default;
  }
});
exports.default = void 0;

var _constants = _interopRequireDefault(require("../constants"));

var _constantsToKeys = require("../webgl-utils/constants-to-keys");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// WEBGL BUILT-IN CONSTANTS
var _default = _constants.default; // Resolve a WebGL enumeration name (returns itself if already a number)

exports.default = _default;

function glGet(name) {
  return (0, _constantsToKeys.getKeyValue)(_constants.default, name);
}

function glKey(value) {
  return (0, _constantsToKeys.getKey)(_constants.default, value);
}

function glKeyType(value) {
  return (0, _constantsToKeys.getKeyType)(_constants.default, value);
}
//# sourceMappingURL=gl-constants.js.map