"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#define SHADER_NAME luma-frag-lighting-fs\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\n#define LIGHT_MAX 4\n\nvarying vec2 vTexCoord1;\nvarying vec2 vTexCoord2;\nvarying vec2 vTexCoord3;\nvarying vec4 vColor;\nvarying vec4 vTransformedNormal;\nvarying vec4 vPosition;\n\nuniform float shininess;\nuniform bool enableSpecularHighlights;\nuniform bool enableLights;\n\nuniform vec3 ambientColor;\nuniform vec3 directionalColor;\nuniform vec3 lightingDirection;\n\nuniform vec3 pointLocation[LIGHT_MAX];\nuniform vec3 pointColor[LIGHT_MAX];\nuniform vec3 pointSpecularColor[LIGHT_MAX];\nuniform float enableSpecular[LIGHT_MAX];\nuniform int numberPoints;\n\nuniform bool hasTexture1;\nuniform sampler2D sampler1;\n\nuniform bool hasTexture2;\nuniform sampler2D sampler2;\n\nuniform bool hasTexture3;\nuniform sampler2D sampler3;\n\nuniform mat4 viewMatrix;\n\nvoid main(void) {\n  vec3 lightWeighting;\n  if (!enableLights) {\n    lightWeighting = vec3(1.0, 1.0, 1.0);\n  } else {\n    vec3 lightDirection;\n    float specularLightWeighting = 0.0;\n    float diffuseLightWeighting = 0.0;\n    vec3  specularLight = vec3(0.0, 0.0, 0.0);\n    vec3  diffuseLight = vec3(0.0, 0.0, 0.0);\n\n    vec3 transformedPointLocation;\n    vec3 normal = vTransformedNormal.xyz;\n\n    vec3 eyeDirection = normalize(-vPosition.xyz);\n    vec3 reflectionDirection;\n\n    vec3 pointWeight = vec3(0.0, 0.0, 0.0);\n\n    for (int i = 0; i < LIGHT_MAX; i++) {\n      if (i < numberPoints) {\n        transformedPointLocation = (viewMatrix * vec4(pointLocation[i], 1.0)).xyz;\n        lightDirection = normalize(transformedPointLocation - vPosition.xyz);\n\n        if (enableSpecular[i] > 0.0) {\n          reflectionDirection = reflect(-lightDirection, normal);\n          specularLightWeighting = pow(max(dot(reflectionDirection, eyeDirection), 0.0), shininess);\n          specularLight += specularLightWeighting * pointSpecularColor[i];\n        }\n\n        diffuseLightWeighting = max(dot(normal, lightDirection), 0.0);\n        diffuseLight += diffuseLightWeighting * pointColor[i];\n      } else {\n        break;\n      }\n    }\n\n    lightWeighting = ambientColor + diffuseLight + specularLight;\n  }\n\n  vec4 fragmentColor = vec4(0.0, 0.0, 0.0, 0.0);\n  if (hasTexture1 || hasTexture2 || hasTexture3) {\n    if (hasTexture1) {\n      fragmentColor += texture2D(sampler1, vec2(vTexCoord1.s, vTexCoord1.t));\n    }\n    if (hasTexture2) {\n      fragmentColor += texture2D(sampler2, vec2(vTexCoord2.s, vTexCoord2.t));\n    }\n    if (hasTexture3) {\n      fragmentColor += texture2D(sampler3, vec2(vTexCoord3.s, vTexCoord3.t));\n    }\n  } else {\n    fragmentColor = vColor;\n  }\n  gl_FragColor = vec4(fragmentColor.rgb * lightWeighting, fragmentColor.a);\n}\n";
exports.default = _default;
//# sourceMappingURL=frag-lighting.fs.glsl.js.map