"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#define SHADER_NAME luma-render-tex-fs\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\n#define LIGHT_MAX 4\n\nvarying vec2 vTexCoord1;\nvarying vec2 vTexCoord2;\nvarying vec2 vTexCoord3;\nvarying vec4 vColor;\nvarying vec4 vTransformedNormal;\nvarying vec4 vPosition;\n\nuniform float shininess;\nuniform bool enableSpecularHighlights;\n\nuniform vec3 ambientColor;\nuniform vec3 directionalColor;\nuniform vec3 lightingDirection;\n\nuniform vec3 pointLocation[LIGHT_MAX];\nuniform vec3 pointColor[LIGHT_MAX];\nuniform vec3 pointSpecularColor[LIGHT_MAX];\nuniform int numberPoints;\n\nuniform vec3 materialAmbientColor;\nuniform vec3 materialDiffuseColor;\nuniform vec3 materialSpecularColor;\nuniform vec3 materialEmissiveColor;\n\nuniform bool hasTexture1;\nuniform sampler2D sampler1;\n\nuniform mat4 viewMatrix;\n\nvoid main(void) {\n  vec3 ambientLightWeighting = ambientColor;\n\n  vec3 lightDirection;\n  float specularLightWeighting = 0.0;\n  float diffuseLightWeighting = 0.0;\n  vec3  specularLight = vec3(0.0, 0.0, 0.0);\n  vec3  diffuseLight = vec3(0.0, 0.0, 0.0);\n\n  vec3 transformedPointLocation;\n  vec3 normal = vTransformedNormal.xyz;\n\n  vec3 eyeDirection = normalize(-vPosition.xyz);\n  vec3 reflectionDirection;\n\n  for (int i = 0; i < LIGHT_MAX; i++) {\n    if (i < numberPoints) {\n      transformedPointLocation = (viewMatrix * vec4(pointLocation[i], 1.0)).xyz;\n      lightDirection = normalize(transformedPointLocation - vPosition.xyz);\n\n      if (enableSpecularHighlights) {\n        reflectionDirection = reflect(-lightDirection, normal);\n        specularLightWeighting = pow(max(dot(reflectionDirection, eyeDirection), 0.0), shininess);\n        specularLight += specularLightWeighting * pointSpecularColor[i];\n      }\n\n      diffuseLightWeighting = max(dot(normal, lightDirection), 0.0);\n      diffuseLight += diffuseLightWeighting * pointColor[i];\n    } else {\n        break;\n    }\n  }\n\n  vec3 matAmbientColor = materialAmbientColor;\n  vec3 matDiffuseColor = materialDiffuseColor;\n  vec3 matSpecularColor = materialSpecularColor;\n  vec3 matEmissiveColor = materialEmissiveColor;\n  float alpha = 1.0;\n  if (hasTexture1) {\n    vec4 textureColor = texture2D(sampler1, vec2(vTexCoord1.s, vTexCoord1.t));\n    matAmbientColor = matAmbientColor * textureColor.rgb;\n    matDiffuseColor = matDiffuseColor * textureColor.rgb;\n    matEmissiveColor = matEmissiveColor * textureColor.rgb;\n    alpha = textureColor.a;\n  }\n  gl_FragColor = vec4(\n    matAmbientColor * ambientLightWeighting\n    + matDiffuseColor * diffuseLightWeighting\n    + matSpecularColor * specularLightWeighting\n    + matEmissiveColor,\n    alpha\n  );\n}\n";
exports.default = _default;
//# sourceMappingURL=render-tex.fs.glsl.js.map