"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "global", {
  enumerable: true,
  get: function get() {
    return _globals.global;
  }
});
exports.default = void 0;

var _isBrowser = _interopRequireDefault(require("./utils/is-browser"));

var _globals = require("./utils/globals");

var _log = _interopRequireDefault(require("./utils/log"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Version detection using babel plugin

/* global __VERSION__ */
var VERSION = typeof "5.3.1" !== 'undefined' ? "5.3.1" : 'untranspiled source';
var STARTUP_MESSAGE = 'set luma.log.priority=1 (or higher) to trace rendering'; // Assign luma.log.priority in console to control logging: \
// 0: none, 1: minimal, 2: verbose, 3: attribute/uniforms, 4: gl logs
// luma.log.break[], set to gl funcs, luma.log.profile[] set to model names`;

if (_globals.global.luma && _globals.global.luma.VERSION !== VERSION) {
  throw new Error("luma.gl - multiple VERSIONs detected: ".concat(_globals.global.luma.VERSION, " vs ").concat(VERSION));
}

if (!_globals.global.luma) {
  if (_isBrowser.default) {
    _log.default.log(0, "luma.gl ".concat(VERSION, " - ").concat(STARTUP_MESSAGE))();
  }

  _globals.global.luma = _globals.global.luma || {
    VERSION: VERSION,
    version: VERSION,
    log: _log.default,
    // A global stats object that various components can add information to
    // E.g. see webgl/resource.js
    stats: {},
    // Keep some luma globals in a sub-object
    // This allows us to dynamically detect if certain modules have been
    // included (such as IO and headless) and enable related functionality,
    // without unconditionally requiring and thus bundling big dependencies
    // into the app.
    globals: {
      modules: {},
      nodeIO: {}
    }
  };
}

var _default = _globals.global.luma;
exports.default = _default;
//# sourceMappingURL=init.js.map