"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "fp64ify", {
  enumerable: true,
  get: function get() {
    return _fp64Utils.fp64ify;
  }
});
Object.defineProperty(exports, "fp64LowPart", {
  enumerable: true,
  get: function get() {
    return _fp64Utils.fp64LowPart;
  }
});
Object.defineProperty(exports, "fp64ifyMatrix4", {
  enumerable: true,
  get: function get() {
    return _fp64Utils.fp64ifyMatrix4;
  }
});
exports.fp64fs = exports.fp64arithmetic = exports.default = void 0;

var _fp64Utils = require("./fp64-utils");

var _fp64Arithmetic = _interopRequireDefault(require("./fp64-arithmetic.glsl"));

var _fp64Functions = _interopRequireDefault(require("./fp64-functions.glsl"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
var fp64shader = "".concat(_fp64Arithmetic.default, "\n").concat(_fp64Functions.default);
var _default = {
  name: 'fp64',
  vs: fp64shader,
  fs: null,
  fp64ify: _fp64Utils.fp64ify,
  fp64LowPart: _fp64Utils.fp64LowPart,
  fp64ifyMatrix4: _fp64Utils.fp64ifyMatrix4
}; // Arithmetic only

exports.default = _default;
var fp64arithmetic = {
  name: 'fp64-arithmetic',
  vs: "".concat(_fp64Arithmetic.default),
  fs: null
}; // Fragment shader fp64

exports.fp64arithmetic = fp64arithmetic;
var fp64fs = {
  name: 'fp64-fs',
  vs: null,
  fs: fp64shader
};
exports.fp64fs = fp64fs;
//# sourceMappingURL=fp64.js.map