"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#ifdef GL_ES\nprecision highp float;\n#endif\n\n#define SHADER_NAME luma-default-fs\n\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvarying vec3 lightWeighting;\n\nuniform bool hasTexture1;\nuniform sampler2D sampler1;\n\nuniform bool enablePicking;\nuniform vec3 pickColor;\n\nuniform bool hasFog;\nuniform vec3 fogColor;\n\nuniform float fogNear;\nuniform float fogFar;\n\nvoid main() {\n  if(!hasTexture1) {\n    gl_FragColor = vec4(vColor.rgb * lightWeighting, vColor.a);\n  } else {\n    gl_FragColor =\n      vec4(texture2D(sampler1, vec2(vTexCoord.s, vTexCoord.t)).rgb * lightWeighting, 1.0);\n  }\n\n  if (enablePicking) {\n    gl_FragColor = vec4(pickColor, 1.0);\n  }\n\n  /* handle fog */\n  if (hasFog) {\n    float depth = gl_FragCoord.z / gl_FragCoord.w;\n    float fogFactor = smoothstep(fogNear, fogFar, depth);\n    gl_FragColor = mix(gl_FragColor, vec4(fogColor, gl_FragColor.w), fogFactor);\n  }\n}\n";
exports.default = _default;
//# sourceMappingURL=default-fragment.glsl.js.map