"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeGL = initializeGL;
exports.initializeTexTarget = initializeTexTarget;
exports.render = render;
exports.getGPUOutput = getGPUOutput;

var _luma = require("luma.gl");

/* eslint-disable max-len, prefer-template, camelcase */

/* global console */

/* eslint-disable no-console */
// Utilities functions that to be moved to a common place for future tests
function glEnumToString(gl, value) {
  // Optimization for the most common enum:
  if (value === gl.NO_ERROR) {
    return 'NO_ERROR';
  }

  for (var p in gl) {
    if (gl[p] === value) {
      return p;
    }
  }

  return '0x' + value.toString(16);
}

function glErrorShouldBe(gl, glErrors, opt_msg) {
  if (!glErrors.length) {
    glErrors = [glErrors];
  }

  opt_msg = opt_msg || '';
  var err = gl.getError();
  var ndx = glErrors.indexOf(err);
  var errStrs = [];

  for (var ii = 0; ii < glErrors.length; ++ii) {
    errStrs.push(glEnumToString(gl, glErrors[ii]));
  } // const expected = errStrs.join(' or ');


  if (ndx < 0) {
    var msg = "getError expected".concat(glErrors.length > 1 ? ' one of: ' : ': ');
    console.error('FAIL ' + msg);
  }
}

function initializeGL(canvas) {
  var gl = (0, _luma.createGLContext)(canvas);
  (0, _luma.setParameters)(gl, {
    viewport: [0, 0, canvas.width, canvas.height],
    clearColor: [0, 0, 0, 1],
    clearDepth: 1
  });
  gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
  return gl;
}

function initializeTexTarget(gl) {
  var framebuffer = gl.createFramebuffer();
  gl.bindFramebuffer(gl.FRAMEBUFFER, framebuffer);
  framebuffer.width = 10;
  framebuffer.height = 10;
  var tex = gl.createTexture();
  gl.bindTexture(gl.TEXTURE_2D, tex);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
  gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA32F, framebuffer.width, framebuffer.height, 0, gl.RGBA, gl.FLOAT, null);
  var renderbuffer = gl.createRenderbuffer();
  gl.bindRenderbuffer(gl.RENDERBUFFER, renderbuffer);
  gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, framebuffer.width, framebuffer.height);
  gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, tex, 0);
  gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, renderbuffer);
}

function render(gl) {
  gl.drawArrays(gl.TRIANGLE_STRIP, 0, 4);
  glErrorShouldBe(gl, gl.NO_ERROR, 'no error from draw');
}

function getGPUOutput(gl) {
  var width = gl.canvas.width;
  var height = gl.canvas.height;
  var buf = new Float32Array(width * height * 4);
  gl.readPixels(0, 0, width, height, gl.RGBA, gl.FLOAT, buf);
  return buf;
}
//# sourceMappingURL=gpu-test-utils.js.map