"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = polyfillContext;

var _assert = _interopRequireDefault(require("../utils/assert"));

var _polyfillGetParameter = require("./polyfill-get-parameter");

var _WEBGL_CONTEXT_POLYFI;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var OES_vertex_array_object = 'OES_vertex_array_object';
var ANGLE_instanced_arrays = 'ANGLE_instanced_arrays';
var WEBGL_draw_buffers = 'WEBGL_draw_buffers';
var EXT_disjoint_timer_query = 'EXT_disjoint_timer_query';
var EXT_disjoint_timer_query_webgl2 = 'EXT_disjoint_timer_query_webgl2';
var EXT_texture_filter_anisotropic = 'EXT_texture_filter_anisotropic';
var ERR_VAO_NOT_SUPPORTED = 'VertexArray requires WebGL2 or OES_vertex_array_object extension'; // Return true if WebGL2 context

function isWebGL2(gl) {
  var GL_TEXTURE_BINDING_3D = 0x806A;
  return gl && gl.TEXTURE_BINDING_3D === GL_TEXTURE_BINDING_3D;
} // Return object with webgl2 flag and an extension


function getExtensionData(gl, extension) {
  return {
    webgl2: isWebGL2(gl),
    ext: gl.getExtension(extension)
  };
} // function mapExtensionConstant(gl, constant) {
//   switch (constant) {
//   case ext.FRAGMENT_SHADER_DERIVATIVE_HINT_OES: return GL.FRAGMENT_SHADER_DERIVATIVE_HINT;
//   }
// }


var WEBGL_CONTEXT_POLYFILLS = (_WEBGL_CONTEXT_POLYFI = {}, _defineProperty(_WEBGL_CONTEXT_POLYFI, OES_vertex_array_object, {
  meta: {
    suffix: 'OES'
  },
  // NEW METHODS
  createVertexArray: function createVertexArray() {
    (0, _assert.default)(false, ERR_VAO_NOT_SUPPORTED);
  },
  deleteVertexArray: function deleteVertexArray() {},
  bindVertexArray: function bindVertexArray() {},
  isVertexArray: function isVertexArray() {
    return false;
  }
}), _defineProperty(_WEBGL_CONTEXT_POLYFI, ANGLE_instanced_arrays, {
  meta: {
    suffix: 'ANGLE' // constants: {
    //   VERTEX_ATTRIB_ARRAY_DIVISOR: 'VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE'
    // }

  },
  vertexAttribDivisor: function vertexAttribDivisor(location, divisor) {
    // Accept divisor 0 even if instancing is not supported (0 = no instancing)
    (0, _assert.default)(divisor === 0, 'WebGL instanced rendering not supported');
  },
  drawElementsInstanced: function drawElementsInstanced() {},
  drawArraysInstanced: function drawArraysInstanced() {}
}), _defineProperty(_WEBGL_CONTEXT_POLYFI, WEBGL_draw_buffers, {
  meta: {
    suffix: 'WEBGL'
  },
  drawBuffers: function drawBuffers() {
    (0, _assert.default)(false);
  }
}), _defineProperty(_WEBGL_CONTEXT_POLYFI, EXT_disjoint_timer_query, {
  meta: {
    suffix: 'EXT'
  },
  // WebGL1: Polyfills the WebGL2 Query API
  createQuery: function createQuery() {
    (0, _assert.default)(false);
  },
  deleteQuery: function deleteQuery() {
    (0, _assert.default)(false);
  },
  beginQuery: function beginQuery() {
    (0, _assert.default)(false);
  },
  endQuery: function endQuery() {},
  getQuery: function getQuery(handle, pname) {
    return this.getQueryObject(handle, pname);
  },
  // The WebGL1 extension uses getQueryObject rather then getQueryParameter
  getQueryParameter: function getQueryParameter(handle, pname) {
    return this.getQueryObject(handle, pname);
  },
  // plus the additional `queryCounter` method
  queryCounter: function queryCounter() {},
  getQueryObject: function getQueryObject() {}
}), _defineProperty(_WEBGL_CONTEXT_POLYFI, EXT_disjoint_timer_query_webgl2, {
  meta: {
    suffix: 'EXT'
  },
  // install `queryCounter`
  // `null` avoids overwriting WebGL1 `queryCounter` if the WebGL2 extension is not available
  queryCounter: null
}), _defineProperty(_WEBGL_CONTEXT_POLYFI, "OVERRIDES", {
  // Ensure readBuffer is a no-op
  readBuffer: function readBuffer(gl, originalFunc, attachment) {
    if (isWebGL2(gl)) {
      originalFunc(attachment);
    } else {// assert(attachment !== GL_COLOR_ATTACHMENT0 && attachment !== GL_FRONT);
    }
  },
  // Override for getVertexAttrib that returns sane values for non-WebGL1 constants
  getVertexAttrib: function getVertexAttrib(gl, originalFunc, location, pname) {
    // const gl = this; // eslint-disable-line
    var _getExtensionData = getExtensionData(gl, ANGLE_instanced_arrays),
        webgl2 = _getExtensionData.webgl2,
        ext = _getExtensionData.ext;

    var GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD;
    var GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE;
    var result;

    switch (pname) {
      // WebGL1 attributes will never be integer
      case GL_VERTEX_ATTRIB_ARRAY_INTEGER:
        result = !webgl2 ? false : undefined;
        break;
      // if instancing is not available, return 0 meaning divisor has not been set

      case GL_VERTEX_ATTRIB_ARRAY_DIVISOR:
        result = !webgl2 && !ext ? 0 : undefined;
        break;

      default:
    }

    return result !== undefined ? result : originalFunc(location, pname);
  },
  // Handle transform feedback and uniform block queries in WebGL1
  getProgramParameter: function getProgramParameter(gl, originalFunc, program, pname) {
    var GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F;
    var GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83;
    var GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36;
    var GL_SEPARATE_ATTRIBS = 0x8C8D;

    if (!isWebGL2(gl)) {
      switch (pname) {
        case GL_TRANSFORM_FEEDBACK_BUFFER_MODE:
          return GL_SEPARATE_ATTRIBS;

        case GL_TRANSFORM_FEEDBACK_VARYINGS:
          return 0;

        case GL_ACTIVE_UNIFORM_BLOCKS:
          return 0;

        default:
      }
    }

    return originalFunc(program, pname);
  },
  getInternalformatParameter: function getInternalformatParameter(gl, originalFunc, target, format, pname) {
    var GL_SAMPLES = 0x80A9;

    if (!isWebGL2(gl)) {
      switch (pname) {
        case GL_SAMPLES:
          return new Int32Array([0]);

        default:
      }
    }

    return gl.getInternalformatParameter(target, format, pname);
  },
  getTexParameter: function getTexParameter(gl, originalFunc, target, pname) {
    var GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE;

    switch (pname) {
      case GL_TEXTURE_MAX_ANISOTROPY_EXT:
        var extensions = gl.luma.extensions;
        var ext = extensions[EXT_texture_filter_anisotropic];
        pname = ext && ext.TEXTURE_MAX_ANISOTROPY_EXT || GL_TEXTURE_MAX_ANISOTROPY_EXT;
        break;

      default:
    }

    return originalFunc(target, pname);
  },
  getParameter: _polyfillGetParameter.getParameterPolyfill,
  hint: function hint(gl, originalFunc, pname, value) {
    // TODO - handle GL.FRAGMENT_SHADER_DERIVATIVE_HINT:
    // switch (pname) {
    // case GL.FRAGMENT_SHADER_DERIVATIVE_HINT:
    // }
    return originalFunc(pname, value);
  }
}), _WEBGL_CONTEXT_POLYFI);

function initializeExtensions(gl) {
  gl.luma.extensions = {};
  var EXTENSIONS = gl.getSupportedExtensions();
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = EXTENSIONS[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var extension = _step.value;
      gl.luma[extension] = gl.getExtension(extension);
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }
} // Polyfills a single WebGL extension into the `target` object


function polyfillExtension(gl, _ref) {
  var extension = _ref.extension,
      target = _ref.target,
      target2 = _ref.target2;
  var defaults = WEBGL_CONTEXT_POLYFILLS[extension];
  (0, _assert.default)(defaults);
  var _defaults$meta = defaults.meta,
      meta = _defaults$meta === void 0 ? {} : _defaults$meta;
  var _meta$suffix = meta.suffix,
      suffix = _meta$suffix === void 0 ? '' : _meta$suffix;
  var ext = gl.getExtension(extension);
  Object.keys(defaults).forEach(function (key) {
    var extKey = "".concat(key).concat(suffix);
    var polyfill = null;

    if (key === 'meta') {// ignore
    } else if (typeof gl[key] === 'function') {// WebGL2 implementation is already
    } else if (ext && typeof ext[extKey] === 'function') {
      // pick extension implemenentation,if available
      polyfill = function polyfill() {
        return ext[extKey].apply(ext, arguments);
      };
    } else if (typeof defaults[key] === 'function') {
      // pick the mock implementation, if no implementation was detected
      polyfill = defaults[key].bind(target);
    }

    if (polyfill) {
      target[key] = polyfill;
      target2[key] = polyfill;
    }
  });
} // Install simple overrides (mostly get* functions)


function installOverrides(gl, _ref2) {
  var target = _ref2.target,
      target2 = _ref2.target2;
  var OVERRIDES = WEBGL_CONTEXT_POLYFILLS.OVERRIDES;
  Object.keys(OVERRIDES).forEach(function (key) {
    if (typeof OVERRIDES[key] === 'function') {
      // install an override, if no implementation was detected
      var originalFunc = gl[key] ? gl[key].bind(gl) : function () {};
      var polyfill = OVERRIDES[key].bind(null, gl, originalFunc);
      target[key] = polyfill;
      target2[key] = polyfill;
    }
  });
} // Registers polyfill or mock functions for all known extensions


function polyfillContext(gl) {
  gl.luma = gl.luma || {};
  initializeExtensions(gl);

  if (!gl.luma.polyfilled) {
    for (var extension in WEBGL_CONTEXT_POLYFILLS) {
      if (extension !== 'overrides') {
        polyfillExtension(gl, {
          extension: extension,
          target: gl.luma,
          target2: gl
        });
      }
    }

    installOverrides(gl, {
      target: gl.luma,
      target2: gl
    });
    gl.luma.polyfilled = true;
  }

  return gl;
}
//# sourceMappingURL=polyfill-context.js.map