"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParameterPolyfill = getParameterPolyfill;

var _constants = _interopRequireDefault(require("../constants"));

var _WEBGL_PARAMETERS;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var OES_element_index = 'OES_element_index';
var WEBGL_draw_buffers = 'WEBGL_draw_buffers';
var EXT_disjoint_timer_query = 'EXT_disjoint_timer_query';
var EXT_disjoint_timer_query_webgl2 = 'EXT_disjoint_timer_query_webgl2';
var EXT_texture_filter_anisotropic = 'EXT_texture_filter_anisotropic';
var WEBGL_debug_renderer_info = 'WEBGL_debug_renderer_info';
var GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B;
var GL_DONT_CARE = 0x1100;
var GL_GPU_DISJOINT_EXT = 0x8FBB;
var GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF;
var GL_UNMASKED_VENDOR_WEBGL = 0x9245; // vendor string of the graphics driver.

var GL_UNMASKED_RENDERER_WEBGL = 0x9246; // renderer string of the graphics driver.

var getWebGL2ValueOrZero = function getWebGL2ValueOrZero(gl) {
  return !isWebGL2(gl) ? 0 : undefined;
}; // if a function returns undefined in this table,
// the original getParameter will be called, defeating the override


var WEBGL_PARAMETERS = (_WEBGL_PARAMETERS = {}, _defineProperty(_WEBGL_PARAMETERS, _constants.default.READ_BUFFER, function (gl) {
  return !isWebGL2(gl) ? _constants.default.COLOR_ATTACHMENT0 : undefined;
}), _defineProperty(_WEBGL_PARAMETERS, GL_FRAGMENT_SHADER_DERIVATIVE_HINT, function (gl) {
  return !isWebGL2(gl) ? GL_DONT_CARE : undefined;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.RASTERIZER_DISCARD, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.SAMPLES, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, GL_GPU_DISJOINT_EXT, function (gl, getParameter) {
  var ext = isWebGL2(gl) ? gl.getExtension(EXT_disjoint_timer_query_webgl2) : gl.getExtension(EXT_disjoint_timer_query);
  return ext && ext.GPU_DISJOINT_EXT ? getParameter(ext.GPU_DISJOINT_EXT) : 0;
}), _defineProperty(_WEBGL_PARAMETERS, GL_UNMASKED_VENDOR_WEBGL, function (gl, getParameter) {
  var ext = gl.getExtension(WEBGL_debug_renderer_info);
  return getParameter(ext && ext.UNMASKED_VENDOR_WEBGL || _constants.default.VENDOR);
}), _defineProperty(_WEBGL_PARAMETERS, GL_UNMASKED_RENDERER_WEBGL, function (gl, getParameter) {
  var ext = gl.getExtension(WEBGL_debug_renderer_info);
  return getParameter(ext && ext.UNMASKED_RENDERER_WEBGL || _constants.default.RENDERER);
}), _defineProperty(_WEBGL_PARAMETERS, GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, function (gl, getParameter) {
  var ext = gl.luma.extensions[EXT_texture_filter_anisotropic];
  return ext ? getParameter(ext.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 1.0;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_3D_TEXTURE_SIZE, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_ARRAY_TEXTURE_LAYERS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_CLIENT_WAIT_TIMEOUT_WEBGL, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_COLOR_ATTACHMENTS, function (gl, getParameter) {
  if (!isWebGL2(gl)) {
    var ext = gl.getExtension(WEBGL_draw_buffers);
    return ext ? getParameter(ext.MAX_COLOR_ATTACHMENTS_WEBGL) : 0;
  }

  return undefined;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_COMBINED_UNIFORM_BLOCKS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_DRAW_BUFFERS, function (gl) {
  if (!isWebGL2(gl)) {
    var ext = gl.getExtension(WEBGL_draw_buffers);
    return ext ? ext.MAX_DRAW_BUFFERS_WEBGL : 0;
  }

  return undefined;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_ELEMENT_INDEX, // Guess: per webglstats.com 99.6% of webgl2 supports 2147483647
function (gl) {
  return gl.getExtension(OES_element_index) ? 2147483647 : 65535;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_ELEMENTS_INDICES, // Guess: "Reasonably safe" per webglstats.com - could be higher/lower (on some mobile devices)
function (gl) {
  return gl.getExtension(OES_element_index) ? 16777216 : 65535;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_ELEMENTS_VERTICES, // Guess: "Reasonably safe" per webglstats.com - could be higher/lower (on some mobile devices)
function (gl) {
  return 16777216;
}), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_FRAGMENT_INPUT_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_FRAGMENT_UNIFORM_BLOCKS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_FRAGMENT_UNIFORM_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_SAMPLES, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_SERVER_WAIT_TIMEOUT, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_TEXTURE_LOD_BIAS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_UNIFORM_BLOCK_SIZE, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_UNIFORM_BUFFER_BINDINGS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_VARYING_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_VERTEX_OUTPUT_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_VERTEX_UNIFORM_BLOCKS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_VERTEX_UNIFORM_COMPONENTS, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MIN_PROGRAM_TEXEL_OFFSET, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.MAX_PROGRAM_TEXEL_OFFSET, getWebGL2ValueOrZero), _defineProperty(_WEBGL_PARAMETERS, _constants.default.UNIFORM_BUFFER_OFFSET_ALIGNMENT, getWebGL2ValueOrZero), _WEBGL_PARAMETERS); // Return true if WebGL2 context

function isWebGL2(gl) {
  var GL_TEXTURE_BINDING_3D = 0x806A;
  return gl && gl.TEXTURE_BINDING_3D === GL_TEXTURE_BINDING_3D;
} // A "replacement" gl.getParameter that accepts "enums" from extensions and WebGL2
// and returns reasonably safe defaults


function getParameterPolyfill(gl, originalGetParameter, pname) {
  // Return mock limits (usually 0) for WebGL2 constants to ensure these
  // can be queries without error
  var limit = WEBGL_PARAMETERS[pname];
  var value = typeof limit === 'function' ? limit(gl, originalGetParameter, pname) : limit;
  var result = value !== undefined ? value : originalGetParameter(pname);
  return result;
}
//# sourceMappingURL=polyfill-get-parameter.js.map