"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrimitiveDrawMode = getPrimitiveDrawMode;
exports.getPrimitiveCount = getPrimitiveCount;
exports.getVertexCount = getVertexCount;

var _assert = _interopRequireDefault(require("../utils/assert"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var GL_POINTS = 0x0;
var GL_LINES = 0x1;
var GL_LINE_LOOP = 0x2;
var GL_LINE_STRIP = 0x3;
var GL_TRIANGLES = 0x4;
var GL_TRIANGLE_STRIP = 0x5;
var GL_TRIANGLE_FAN = 0x6; // Counts the number of complete primitives given a number of vertices and a drawMode

function getPrimitiveDrawMode(drawMode) {
  switch (drawMode) {
    case GL_POINTS:
      return GL_POINTS;

    case GL_LINES:
      return GL_LINES;

    case GL_LINE_STRIP:
      return GL_LINES;

    case GL_LINE_LOOP:
      return GL_LINES;

    case GL_TRIANGLES:
      return GL_TRIANGLES;

    case GL_TRIANGLE_STRIP:
      return GL_TRIANGLES;

    case GL_TRIANGLE_FAN:
      return GL_TRIANGLES;

    default:
      (0, _assert.default)(false);
      return 0;
  }
} // Counts the number of complete "primitives" given a number of vertices and a drawMode


function getPrimitiveCount(_ref) {
  var drawMode = _ref.drawMode,
      vertexCount = _ref.vertexCount;

  switch (drawMode) {
    case GL_POINTS:
    case GL_LINE_LOOP:
      return vertexCount;

    case GL_LINES:
      return vertexCount / 2;

    case GL_LINE_STRIP:
      return vertexCount - 1;

    case GL_TRIANGLES:
      return vertexCount / 3;

    case GL_TRIANGLE_STRIP:
    case GL_TRIANGLE_FAN:
      return vertexCount - 2;

    default:
      (0, _assert.default)(false);
      return 0;
  }
} // Counts the number of vertices after splitting the vertex stream into separate "primitives"


function getVertexCount(_ref2) {
  var drawMode = _ref2.drawMode,
      vertexCount = _ref2.vertexCount;
  var primitiveCount = getPrimitiveCount({
    drawMode: drawMode,
    vertexCount: vertexCount
  });

  switch (getPrimitiveDrawMode(drawMode)) {
    case GL_POINTS:
      return primitiveCount;

    case GL_LINES:
      return primitiveCount * 2;

    case GL_TRIANGLES:
      return primitiveCount * 3;

    default:
      (0, _assert.default)(false);
      return 0;
  }
}
//# sourceMappingURL=attribute-utils.js.map