"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RENDERBUFFER_FORMATS = void 0;

var _constants = _interopRequireDefault(require("../constants"));

var _webglUtils = require("../webgl-utils");

var _resource = _interopRequireDefault(require("./resource"));

var _assert = _interopRequireDefault(require("../utils/assert"));

var _RENDERBUFFER_FORMATS;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Define local GL constants to optimize minification
var GL_RENDERBUFFER = 0x8D41;
var GL_SAMPLES = 0x80A9;
var GL_RENDERBUFFER_WIDTH = 0x8D42;
var GL_RENDERBUFFER_HEIGHT = 0x8D43;
var GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44;
var GL_RENDERBUFFER_SAMPLES = 0x8CAB; // Define local extension strings to optimize minification
// const SRGB = 'EXT_sRGB';
// const CB_FLOAT_WEBGL1 = 'WEBGL_color_buffer_float';

var CB_FLOAT_WEBGL2 = 'EXT_color_buffer_float'; // const CB_HALF_FLOAT_WEBGL1 = 'EXT_color_buffer_half_float';

var RENDERBUFFER_FORMATS = (_RENDERBUFFER_FORMATS = {}, _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.DEPTH_COMPONENT16, {}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.DEPTH_COMPONENT24, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.DEPTH_COMPONENT32F, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.STENCIL_INDEX8, {}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.DEPTH_STENCIL, {}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.DEPTH24_STENCIL8, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.DEPTH32F_STENCIL8, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA4, {}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGB565, {}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGB5_A1, {}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R8, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R8UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R8I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R16UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R16I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R32UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R32I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG8, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG8UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG8I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG16UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG16I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG32UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG32I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGB8, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA8, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGB10_A2, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA8UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA8I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGB10_A2UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA16UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA16I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA32I, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA32UI, {
  gl2: true
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R16F, {
  gl2: CB_FLOAT_WEBGL2
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG16F, {
  gl2: CB_FLOAT_WEBGL2
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA16F, {
  gl2: CB_FLOAT_WEBGL2
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R32F, {
  gl2: CB_FLOAT_WEBGL2
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RG32F, {
  gl2: CB_FLOAT_WEBGL2
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.RGBA32F, {
  gl2: CB_FLOAT_WEBGL2
}), _defineProperty(_RENDERBUFFER_FORMATS, _constants.default.R11F_G11F_B10F, {
  gl2: CB_FLOAT_WEBGL2
}), _RENDERBUFFER_FORMATS);
exports.RENDERBUFFER_FORMATS = RENDERBUFFER_FORMATS;

function isFormatSupported(gl, format, formats) {
  var info = formats[format];

  if (!info) {
    return false;
  }

  var value = (0, _webglUtils.isWebGL2)(gl) ? info.gl2 || info.gl1 : info.gl1;

  if (typeof value === 'string') {
    return gl.getExtension(value);
  }

  return value;
}

var Renderbuffer =
/*#__PURE__*/
function (_Resource) {
  _inherits(Renderbuffer, _Resource);

  _createClass(Renderbuffer, null, [{
    key: "isSupported",
    value: function isSupported(gl) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          format = _ref.format;

      return !format || isFormatSupported(gl, format, RENDERBUFFER_FORMATS);
    }
  }, {
    key: "getSamplesForFormat",
    value: function getSamplesForFormat(gl, _ref2) {
      var format = _ref2.format;
      // Polyfilled to return [0] under WebGL1
      return gl.getInternalformatParameter(GL_RENDERBUFFER, format, GL_SAMPLES);
    }
  }]);

  function Renderbuffer(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Renderbuffer);

    _this = _possibleConstructorReturn(this, (Renderbuffer.__proto__ || Object.getPrototypeOf(Renderbuffer)).call(this, gl, opts));

    _this.initialize(opts);

    Object.seal(_assertThisInitialized(_this));
    return _this;
  } // Creates and initializes a renderbuffer object's data store


  _createClass(Renderbuffer, [{
    key: "initialize",
    value: function initialize(_ref3) {
      var format = _ref3.format,
          _ref3$width = _ref3.width,
          width = _ref3$width === void 0 ? 1 : _ref3$width,
          _ref3$height = _ref3.height,
          height = _ref3$height === void 0 ? 1 : _ref3$height,
          _ref3$samples = _ref3.samples,
          samples = _ref3$samples === void 0 ? 0 : _ref3$samples;
      (0, _assert.default)(format, 'Needs format');
      this.gl.bindRenderbuffer(GL_RENDERBUFFER, this.handle);

      if (samples !== 0 && (0, _webglUtils.isWebGL2)(this.gl)) {
        this.gl.renderbufferStorageMultisample(GL_RENDERBUFFER, samples, format, width, height);
      } else {
        this.gl.renderbufferStorage(GL_RENDERBUFFER, format, width, height);
      } // this.gl.bindRenderbuffer(GL_RENDERBUFFER, null);


      this.format = format;
      this.width = width;
      this.height = height;
      this.samples = samples;
      return this;
    }
  }, {
    key: "resize",
    value: function resize(_ref4) {
      var width = _ref4.width,
          height = _ref4.height;

      // Don't resize if width/height haven't changed
      if (width !== this.width || height !== this.height) {
        return this.initialize({
          width: width,
          height: height,
          format: this.format,
          samples: this.samples
        });
      }

      return this;
    } // PRIVATE METHODS

  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createRenderbuffer();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteRenderbuffer(this.handle);
    }
  }, {
    key: "_syncHandle",
    value: function _syncHandle(handle) {
      this.format = this.getParameter(GL_RENDERBUFFER_INTERNAL_FORMAT);
      this.width = this.getParameter(GL_RENDERBUFFER_WIDTH);
      this.height = this.getParameter(GL_RENDERBUFFER_HEIGHT);
      this.samples = this.getParameter(GL_RENDERBUFFER_SAMPLES);
    } // @param {Boolean} opt.autobind=true - method call will bind/unbind object
    // @returns {GLenum|GLint} - depends on pname

  }, {
    key: "_getParameter",
    value: function _getParameter(pname) {
      this.gl.bindRenderbuffer(GL_RENDERBUFFER, this.handle);
      var value = this.gl.getRenderbufferParameter(GL_RENDERBUFFER, pname); // this.gl.bindRenderbuffer(GL_RENDERBUFFER, null);

      return value;
    }
  }]);

  return Renderbuffer;
}(_resource.default);

exports.default = Renderbuffer;
//# sourceMappingURL=renderbuffer.js.map