function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import { createGLContext, resizeGLContext, resetParameters } from '../webgl-context';
import { pageLoadPromise } from '../webgl-context';
import { makeDebugContext } from '../webgl-context/debug-context';
import { isWebGL, requestAnimationFrame, cancelAnimationFrame } from '../webgl-utils';
import { log } from '../utils';
import assert from '../utils/assert'; // TODO - remove dependency on webgl classes

import { Framebuffer } from '../webgl';
var DEFAULT_GL_OPTIONS = {
  preserveDrawingBuffer: true
};

var AnimationLoop =
/*#__PURE__*/
function () {
  /*
   * @param {HTMLCanvasElement} canvas - if provided, width and height will be passed to context
   */
  function AnimationLoop() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, AnimationLoop);

    var _props$onCreateContex = props.onCreateContext,
        onCreateContext = _props$onCreateContex === void 0 ? function (opts) {
      return createGLContext(opts);
    } : _props$onCreateContex,
        _props$onInitialize = props.onInitialize,
        onInitialize = _props$onInitialize === void 0 ? function () {} : _props$onInitialize,
        _props$onRender = props.onRender,
        onRender = _props$onRender === void 0 ? function () {} : _props$onRender,
        _props$onFinalize = props.onFinalize,
        onFinalize = _props$onFinalize === void 0 ? function () {} : _props$onFinalize,
        _props$offScreen = props.offScreen,
        offScreen = _props$offScreen === void 0 ? false : _props$offScreen,
        _props$gl = props.gl,
        gl = _props$gl === void 0 ? null : _props$gl,
        _props$glOptions = props.glOptions,
        glOptions = _props$glOptions === void 0 ? {} : _props$glOptions,
        _props$debug = props.debug,
        debug = _props$debug === void 0 ? false : _props$debug,
        _props$createFramebuf = props.createFramebuffer,
        createFramebuffer = _props$createFramebuf === void 0 ? false : _props$createFramebuf,
        _props$autoResizeView = props.autoResizeViewport,
        autoResizeViewport = _props$autoResizeView === void 0 ? true : _props$autoResizeView,
        _props$autoResizeDraw = props.autoResizeDrawingBuffer,
        autoResizeDrawingBuffer = _props$autoResizeDraw === void 0 ? true : _props$autoResizeDraw;
    var _props$useDevicePixel = props.useDevicePixels,
        useDevicePixels = _props$useDevicePixel === void 0 ? true : _props$useDevicePixel;

    if ('useDevicePixelRatio' in props) {
      log.deprecated('useDevicePixelRatio', 'useDevicePixels')();
      useDevicePixels = props.useDevicePixelRatio;
    }

    this.props = {
      onCreateContext: onCreateContext,
      onInitialize: onInitialize,
      onRender: onRender,
      onFinalize: onFinalize,
      gl: gl,
      glOptions: glOptions,
      debug: debug,
      createFramebuffer: createFramebuffer
    }; // state

    this.gl = gl;
    this.offScreen = offScreen;
    this.needsRedraw = null;
    this.setProps({
      autoResizeViewport: autoResizeViewport,
      autoResizeDrawingBuffer: autoResizeDrawingBuffer,
      useDevicePixels: useDevicePixels
    }); // Bind methods

    this.start = this.start.bind(this);
    this.stop = this.stop.bind(this);
    this._renderFrame = this._renderFrame.bind(this);
    return this;
  }

  _createClass(AnimationLoop, [{
    key: "setNeedsRedraw",
    value: function setNeedsRedraw(reason) {
      assert(typeof reason === 'string');
      this.needsRedraw = this.needsRedraw || reason;
      return this;
    }
  }, {
    key: "setProps",
    value: function setProps(props) {
      if ('autoResizeViewport' in props) {
        this.autoResizeViewport = props.autoResizeViewport;
      }

      if ('autoResizeDrawingBuffer' in props) {
        this.autoResizeDrawingBuffer = props.autoResizeDrawingBuffer;
      }

      if ('useDevicePixels' in props) {
        this.useDevicePixels = props.useDevicePixels;
      }

      return this;
    } // Starts a render loop if not already running
    // @param {Object} context - contains frame specific info (E.g. tick, width, height, etc)

  }, {
    key: "start",
    value: function start() {
      var _this = this;

      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this._stopped = false; // console.debug(`Starting ${this.constructor.name}`);

      if (!this._animationFrameId) {
        // Wait for start promise before rendering frame
        this._startPromise = pageLoadPromise.then(function () {
          if (_this._stopped) {
            return null;
          } // Create the WebGL context


          _this._createWebGLContext(opts);

          _this._createFramebuffer(); // Initialize the callback data


          _this._initializeCallbackData();

          _this._updateCallbackData(); // Default viewport setup, in case onInitialize wants to render


          _this._resizeCanvasDrawingBuffer();

          _this._resizeViewport(); // Note: onIntialize can return a promise (in case it needs to load resources)


          return _this.props.onInitialize(_this._callbackData);
        }).then(function (appContext) {
          if (!_this._stopped) {
            _this._addCallbackData(appContext || {});

            if (appContext !== false && !_this._animationFrameId) {
              _this._animationFrameId = requestAnimationFrame(_this._renderFrame);
            }
          }
        });
      }

      return this;
    } // Stops a render loop if already running, finalizing

  }, {
    key: "stop",
    value: function stop() {
      // console.debug(`Stopping ${this.constructor.name}`);
      if (this._animationFrameId) {
        this._finalizeCallbackData();

        cancelAnimationFrame(this._animationFrameId);
        this._animationFrameId = null;
        this._stopped = true;
      }

      return this;
    } // DEPRECATED METHODS
    // Update parameters

  }, {
    key: "setViewParameters",
    value: function setViewParameters(_ref) {
      var _ref$autoResizeDrawin = _ref.autoResizeDrawingBuffer,
          autoResizeDrawingBuffer = _ref$autoResizeDrawin === void 0 ? true : _ref$autoResizeDrawin,
          _ref$autoResizeCanvas = _ref.autoResizeCanvas,
          autoResizeCanvas = _ref$autoResizeCanvas === void 0 ? true : _ref$autoResizeCanvas,
          _ref$autoResizeViewpo = _ref.autoResizeViewport,
          autoResizeViewport = _ref$autoResizeViewpo === void 0 ? true : _ref$autoResizeViewpo,
          _ref$useDevicePixels = _ref.useDevicePixels,
          useDevicePixels = _ref$useDevicePixels === void 0 ? true : _ref$useDevicePixels,
          _ref$useDevicePixelRa = _ref.useDevicePixelRatio,
          useDevicePixelRatio = _ref$useDevicePixelRa === void 0 ? null : _ref$useDevicePixelRa;
      log.deprecated('AnimationLoop.setViewParameters', 'AnimationLoop.setProps')();
      this.autoResizeViewport = autoResizeViewport;
      this.autoResizeCanvas = autoResizeCanvas;
      this.autoResizeDrawingBuffer = autoResizeDrawingBuffer;
      this.useDevicePixels = useDevicePixels;

      if (useDevicePixelRatio !== null) {
        log.deprecated('useDevicePixelRatio', 'useDevicePixels')();
        this.useDevicePixels = useDevicePixelRatio;
      }

      return this;
    } // PRIVATE METHODS

  }, {
    key: "_setupFrame",
    value: function _setupFrame() {
      if (this._onSetupFrame) {
        // call callback
        this._onSetupFrame(this._callbackData); // end callback

      } else {
        this._resizeCanvasDrawingBuffer();

        this._resizeViewport();

        this._resizeFramebuffer();
      }
    }
    /**
     * @private
     * Handles a render loop frame - updates context and calls the application
     * callback
     */

  }, {
    key: "_renderFrame",
    value: function _renderFrame() {
      if (this._stopped) {
        return;
      }

      this._setupFrame();

      this._updateCallbackData(); // call callback


      this.props.onRender(this._callbackData); // end callback

      if (this.offScreen) {
        // commit returns a Promise
        this.gl.commit().then(this._renderFrame);
      } else {
        // Request another render frame (now )
        this._animationFrameId = requestAnimationFrame(this._renderFrame);
      }
    } // Initialize the  object that will be passed to app callbacks

  }, {
    key: "_initializeCallbackData",
    value: function _initializeCallbackData() {
      this._callbackData = {
        gl: this.gl,
        canvas: this.gl.canvas,
        framebuffer: this.framebuffer,
        stop: this.stop,
        // Initial values
        useDevicePixels: this.useDevicePixels,
        needsRedraw: null,
        tick: 0,
        tock: 0
      };
    } // Update the context object that will be passed to app callbacks

  }, {
    key: "_updateCallbackData",
    value: function _updateCallbackData() {
      // CallbackData width and height represent drawing buffer width and height
      var width = this.gl.drawingBufferWidth;
      var height = this.gl.drawingBufferHeight;

      if (width !== this._callbackData.width || height !== this._callbackData.height) {
        this.setNeedsRedraw('drawing buffer resized');
      }

      this._callbackData.width = width;
      this._callbackData.height = height;
      this._callbackData.aspect = width / height;
      this._callbackData.needsRedraw = this.needsRedraw;
      this._callbackData.offScreen = this.offScreen; // Update redraw reason

      this._callbackData.needsRedraw = this.needsRedraw;
      this.needsRedraw = null; // Increment tick

      this._callbackData.tick++;
    }
  }, {
    key: "_finalizeCallbackData",
    value: function _finalizeCallbackData() {
      // call callback
      this.props.onFinalize(this._callbackData); // end callback
    } // Add application's data to the app context object

  }, {
    key: "_addCallbackData",
    value: function _addCallbackData(appContext) {
      if (_typeof(appContext) === 'object' && appContext !== null) {
        this._callbackData = Object.assign({}, this._callbackData, appContext);
      }
    } // Either uses supplied or existing context, or calls provided callback to create one

  }, {
    key: "_createWebGLContext",
    value: function _createWebGLContext(opts) {
      // Create the WebGL context if necessary
      opts = Object.assign({}, opts, DEFAULT_GL_OPTIONS, this.props.glOptions);
      this.gl = this.props.gl || this.props.onCreateContext(opts);

      if (!isWebGL(this.gl)) {
        throw new Error('AnimationLoop.onCreateContext - illegal context returned');
      }

      if (this.props.debug) {
        this.gl = makeDebugContext(this.gl);
      } // Reset the WebGL context.


      resetParameters(this.gl);
    } // Default viewport setup

  }, {
    key: "_resizeViewport",
    value: function _resizeViewport() {
      if (this.autoResizeViewport) {
        this.gl.viewport(0, 0, this.gl.drawingBufferWidth, this.gl.drawingBufferHeight);
      }
    } // Resize the render buffer of the canvas to match canvas client size
    // Optionally multiplying with devicePixel ratio

  }, {
    key: "_resizeCanvasDrawingBuffer",
    value: function _resizeCanvasDrawingBuffer() {
      if (this.autoResizeDrawingBuffer) {
        resizeGLContext(this.gl, {
          useDevicePixels: this.useDevicePixels
        });
      }
    } // TBD - deprecated?

  }, {
    key: "_createFramebuffer",
    value: function _createFramebuffer() {
      // Setup default framebuffer
      if (this.props.createFramebuffer) {
        this.framebuffer = new Framebuffer(this.gl);
      }
    }
  }, {
    key: "_resizeFramebuffer",
    value: function _resizeFramebuffer() {
      if (this.framebuffer) {
        this.framebuffer.resize({
          width: this.gl.drawingBufferWidth,
          height: this.gl.drawingBufferHeight
        });
      }
    }
  }]);

  return AnimationLoop;
}();

export { AnimationLoop as default };
//# sourceMappingURL=animation-loop.js.map