function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var NULL_PICKING_COLOR = new Uint8Array([0, 0, 0]); // Encodes an index as a Uint8Array([r, g, b]) format picking color

export function encodePickingColor(i) {
  return [i + 1 & 255, i + 1 >> 8 & 255, i + 1 >> 16 & 255];
} // Decodes a picking color in [r, g, b] format to an index

export function decodePickingColor(color) {
  // assert(color instanceof Uint8Array);
  var _color = _slicedToArray(color, 3),
      i1 = _color[0],
      i2 = _color[1],
      i3 = _color[2]; // 1 was added to seperate from no selection


  var index = i1 + i2 * 256 + i3 * 65536 - 1;
  return index;
} // Return picking color representing no item at that pixel

export function getNullPickingColor() {
  return NULL_PICKING_COLOR;
}
//# sourceMappingURL=picking-colors.js.map