function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

/* eslint-disable no-try-catch */
import { isBrowser } from '../../utils';
import assert from 'assert'; // TODO hack - trick filesaver.js to skip loading under node

/* global global*/

var savedNavigatorExists = 'navigator' in global;
var savedNavigator = global.navigator;

if (!isBrowser) {
  global.navigator = {
    userAgent: 'MSIE 9.'
  };
}

var saveAs = require('filesaver.js');

if (!isBrowser) {
  if (savedNavigatorExists) {
    global.navigator = savedNavigator;
  } else {
    delete global.navigator;
  }
} // END hack


var window = require('global/window');

var File = window.File;
var Blob = window.Blob;
/**
 * File system write function for the browser, similar to Node's fs.writeFile
 *
 * Saves a file by downloading it with the given file name.
 *
 * @param {String} file - file name
 * @param {String|Blob} data - data to be written to file
 * @param {String|Object} options -
 * @param {Function} callback - Standard node (err, data) callback
 * @return {Promise} - promise, can be used instead of callback
 */

export function writeFile(file, data, options) {
  var callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};

  // options is optional
  if (callback === undefined && typeof options === 'function') {
    options = undefined;
    callback = options;
  }

  if (typeof data === 'string') {
    data = new Blob(data);
  }

  return new Promise(function (resolve, reject) {
    var result;

    try {
      result = saveAs(data, file, options);
    } catch (error) {
      reject(error);
      return callback(error, null);
    }

    resolve();
    return callback(null, result);
  });
}
/**
 * File reader function for the browser, intentionally similar
 * to node's fs.readFile API, however returns a Promise rather than
 * callbacks
 *
 * @param {File|Blob} file  HTML File or Blob object to read as string
 * @returns {Promise.string}  Resolves to a string containing file contents
 */

export function readFile(file) {
  return new Promise(function (resolve, reject) {
    try {
      assert(File, 'window.File not defined. Must run under browser.');
      assert(_instanceof(file, File), 'parameter must be a File object');
      var reader = new window.FileReader();

      reader.onerror = function (e) {
        return reject(new Error(getFileErrorMessage(e)));
      };

      reader.onabort = function () {
        return reject(new Error('Read operation was aborted.'));
      };

      reader.onload = function () {
        return resolve(reader.result);
      };

      reader.readAsText(file);
    } catch (error) {
      reject(error);
    }
  });
} // NOTES ON ERROR HANDLING
//
// Prepared to externalize error message texts
//
// The weird thing about the FileReader API is that the error definitions
// are only available on the error event instance that is passed to the
// handler. Thus we need to create definitions that are avialble outside
// the handler.
//
// https://developer.mozilla.org/en-US/docs/Web/API/FileReader
//
// Side Note: To complicate matters, there are also a DOMError string set on
// filereader object (error property). Not clear how or if these map
// to the event error codes. These strings are not currently used by this api.
//
// https://developer.mozilla.org/en-US/docs/Web/API/DOMError

function getFileErrorMessage(e) {
  // Map event's error codes to static error codes so that we can
  // externalize error code to error message mapping
  switch (e.target.error.code) {
    case e.target.error.NOT_FOUND_ERR:
      return 'File not found.';

    case e.target.error.NOT_READABLE_ERR:
      return 'File not readable.';

    case e.target.error.ABORT_ERR:
      return 'Read operation was aborted.';

    case e.target.error.SECURITY_ERR:
      return 'File is in a locked state.';

    case e.target.error.ENCODING_ERR:
      return 'File is too long to encode in "data://" URL.';

    default:
      return 'Read error.';
  }
}
//# sourceMappingURL=browser-fs.js.map