function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

import GL from '../constants';
import Resource from './resource';
import { assertWebGL2Context } from '../webgl-utils';
import queryManager from '../webgl-utils/query-manager';

var FenceSync =
/*#__PURE__*/
function (_Resource) {
  _inherits(FenceSync, _Resource);

  /*
   * @class
   * @param {WebGL2RenderingContext} gl
   */
  function FenceSync(gl, opts) {
    var _this;

    _classCallCheck(this, FenceSync);

    assertWebGL2Context(gl);
    _this = _possibleConstructorReturn(this, (FenceSync.__proto__ || Object.getPrototypeOf(FenceSync)).call(this, gl, opts)); // query manager needs a promise field

    _this.promise = null;
    Object.seal(_assertThisInitialized(_this));
    return _this;
  }
  /**
   * The method is a no-op in the absence of the possibility of
   * synchronizing between multiple GL contexts.
   * Prevent commands from being added to GPU command queue.
   * Note: commands can still be buffered in driver.
   *
   * @param {GLbitfield} flags
   * @param {GLint64} timeout
   * @return {Sync} status
   */


  _createClass(FenceSync, [{
    key: "wait",
    value: function wait() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$flags = _ref.flags,
          flags = _ref$flags === void 0 ? 0 : _ref$flags,
          _ref$timeout = _ref.timeout,
          timeout = _ref$timeout === void 0 ? GL.TIMEOUT_IGNORED : _ref$timeout;

      this.gl.waitSync(this.handle, flags, timeout);
      return this;
    }
    /**
     * Block all CPU operations until fence is signalled
     * @param {GLbitfield} flags
     * @param {GLint64} timeout
     * @return {GLenum} result
     */

  }, {
    key: "clientWait",
    value: function clientWait(_ref2) {
      var _ref2$flags = _ref2.flags,
          flags = _ref2$flags === void 0 ? GL.SYNC_FLUSH_COMMANDS_BIT : _ref2$flags,
          timeout = _ref2.timeout;
      var result = this.gl.clientWaitSync(this.handle, flags, timeout); // TODO - map to boolean?

      switch (result) {
        case GL.ALREADY_SIGNALED:
          // Indicates that sync object was signaled when this method was called.
          break;

        case GL.TIMEOUT_EXPIRED:
          // Indicates that timeout time passed, sync object did not become signaled
          break;

        case GL.CONDITION_SATISFIED:
          // Indicates that sync object was signaled before timeout expired.
          break;

        case GL.WAIT_FAILED:
          // Indicates that an error occurred during execution.
          break;

        default:
      }

      return result;
    }
  }, {
    key: "cancel",
    value: function cancel() {
      queryManager.cancelQuery(this);
    }
  }, {
    key: "isSignaled",
    value: function isSignaled() {
      return this.getParameter(GL.SYNC_STATUS) === GL.SIGNALED;
    } // TODO - Query manager needs these?

  }, {
    key: "isResultAvailable",
    value: function isResultAvailable() {
      return this.isSignaled();
    }
  }, {
    key: "getResult",
    value: function getResult() {
      return this.isSignaled();
    }
  }, {
    key: "getParameter",
    value: function getParameter(pname) {
      return this.gl.getSyncParameter(this.handle, pname);
    } // PRIVATE METHODS

  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.fenceSync(GL.SYNC_GPU_COMMANDS_COMPLETE, 0);
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      queryManager.deleteQuery(this);
      this.gl.deleteSync(this.handle);
    }
  }]);

  return FenceSync;
}(Resource);

export { FenceSync as default };
//# sourceMappingURL=fence-sync.js.map