function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

import Resource from './resource';
import { isWebGL2, assertWebGL2Context } from '../webgl-utils';
import assert from '../utils/assert';
var GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E;
var GL_TRANSFORM_FEEDBACK = 0x8E22;

var TranformFeedback =
/*#__PURE__*/
function (_Resource) {
  _inherits(TranformFeedback, _Resource);

  _createClass(TranformFeedback, null, [{
    key: "isSupported",
    value: function isSupported(gl) {
      return isWebGL2(gl);
    }
  }, {
    key: "isHandle",
    value: function isHandle(handle) {
      return this.gl.isTransformFeedback(this.handle);
    }
    /**
     * @class
     * @param {WebGL2RenderingContext} gl - context
     * @param {Object} opts - options
     */

  }]);

  function TranformFeedback(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, TranformFeedback);

    assertWebGL2Context(gl);
    _this = _possibleConstructorReturn(this, (TranformFeedback.__proto__ || Object.getPrototypeOf(TranformFeedback)).call(this, gl, opts));
    _this.buffers = {};
    Object.seal(_assertThisInitialized(_this));

    _this.initialize(opts);

    return _this;
  }

  _createClass(TranformFeedback, [{
    key: "initialize",
    value: function initialize(_ref) {
      var _ref$buffers = _ref.buffers,
          buffers = _ref$buffers === void 0 ? {} : _ref$buffers,
          _ref$varyingMap = _ref.varyingMap,
          varyingMap = _ref$varyingMap === void 0 ? {} : _ref$varyingMap;
      this.bindBuffers(buffers, {
        clear: true,
        varyingMap: varyingMap
      });
    }
  }, {
    key: "bindBuffers",
    value: function bindBuffers() {
      var buffers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref2$clear = _ref2.clear,
          clear = _ref2$clear === void 0 ? false : _ref2$clear,
          _ref2$varyingMap = _ref2.varyingMap,
          varyingMap = _ref2$varyingMap === void 0 ? {} : _ref2$varyingMap;

      if (clear) {
        this._unbindBuffers();

        this.buffers = {};
      }

      for (var bufferName in buffers) {
        var buffer = buffers[bufferName];
        var index = Number.isFinite(Number(bufferName)) ? Number(bufferName) : varyingMap[bufferName];
        assert(Number.isFinite(index));
        this.buffers[index] = buffer;
      }
    } // TODO: Activation is tightly coupled to the current program. Since we try to encapsulate
    // program.use, should we move these methods (begin/pause/resume/end) to the Program?

  }, {
    key: "begin",
    value: function begin(primitiveMode) {
      this._bindBuffers();

      this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, this.handle);
      this.gl.beginTransformFeedback(primitiveMode);
      return this;
    }
  }, {
    key: "pause",
    value: function pause() {
      // Rebinding to same handle seem to cause an issue , first found in Chrome version 67.
      // this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, this.handle);
      this.gl.pauseTransformFeedback();
      this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, null);

      this._unbindBuffers();

      return this;
    }
  }, {
    key: "resume",
    value: function resume() {
      this._bindBuffers();

      this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, this.handle);
      this.gl.resumeTransformFeedback();
      return this;
    }
  }, {
    key: "end",
    value: function end() {
      // Rebinding to same handle seem to cause an issue , first found in Chrome version 67.
      // this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, this.handle);
      this.gl.endTransformFeedback();
      this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, null);

      this._unbindBuffers();

      return this;
    }
  }, {
    key: "bindBuffer",
    value: function bindBuffer(_ref3) {
      var index = _ref3.index,
          buffer = _ref3.buffer,
          _ref3$offset = _ref3.offset,
          offset = _ref3$offset === void 0 ? 0 : _ref3$offset,
          size = _ref3.size;
      // Need to avoid chrome bug where buffer that is already bound to a different target
      // cannot be bound to 'TRANSFORM_FEEDBACK_BUFFER' target.
      buffer.unbind();
      this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, this.handle);

      if (size === undefined) {
        this.gl.bindBufferBase(GL_TRANSFORM_FEEDBACK_BUFFER, index, buffer.handle);
      } else {
        this.gl.bindBufferRange(GL_TRANSFORM_FEEDBACK_BUFFER, index, buffer.handle, offset, size);
      }

      return this;
    }
  }, {
    key: "unbindBuffer",
    value: function unbindBuffer(_ref4) {
      var index = _ref4.index;
      this.gl.bindTransformFeedback(GL_TRANSFORM_FEEDBACK, this.handle);
      this.gl.bindBufferBase(GL_TRANSFORM_FEEDBACK_BUFFER, index, null);
      return this;
    } // PRIVATE METHODS
    // See https://github.com/KhronosGroup/WebGL/issues/2346
    // If it was true that having a buffer on an unused TF was a problem
    // it would make the entire concept of transform feedback objects pointless.
    // The whole point of them is like VertexArrayObjects.
    // You set them up with all in outputs at init time and
    // then in one call you can setup all the outputs just before drawing.
    // Since the point of transform feedback is to generate data that will
    // then be used as inputs to attributes it makes zero sense you'd
    // have to unbind them from every unused transform feedback object
    // before you could use them in an attribute. If that was the case
    // there would be no reason to setup transform feedback objects ever.
    // You'd always use the default because you'd always have to bind and
    // unbind all the buffers.

  }, {
    key: "_bindBuffers",
    value: function _bindBuffers() {
      for (var bufferIndex in this.buffers) {
        this.bindBuffer({
          buffer: this.buffers[bufferIndex],
          index: Number(bufferIndex)
        });
      }
    }
  }, {
    key: "_unbindBuffers",
    value: function _unbindBuffers() {
      for (var bufferIndex in this.buffers) {
        this.unbindBuffer({
          buffer: this.buffers[bufferIndex],
          index: Number(bufferIndex)
        });
      }
    } // RESOURCE METHODS

  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createTransformFeedback();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteTransformFeedback(this.handle);
    }
  }]);

  return TranformFeedback;
}(Resource);

export { TranformFeedback as default };
//# sourceMappingURL=transform-feedback.js.map