var _UNIFORM_TYPES;

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable camelcase */
import assert from '../utils/assert';
var ERR_ARGUMENT = 'UniformBufferLayout illegal argument'; // Local constants - these will "collapse" during minification

var GL_INT = 0x1404;
var GL_INT_VEC2 = 0x8B53;
var GL_INT_VEC3 = 0x8B54;
var GL_INT_VEC4 = 0x8B55;
var GL_FLOAT = 0x1406;
var GL_FLOAT_VEC2 = 0x8B50;
var GL_FLOAT_VEC3 = 0x8B51;
var GL_FLOAT_VEC4 = 0x8B52;
var GL_BOOL = 0x8B56;
var GL_BOOL_VEC2 = 0x8B57;
var GL_BOOL_VEC3 = 0x8B58;
var GL_BOOL_VEC4 = 0x8B59;
var GL_UNSIGNED_INT = 0x1405;
var GL_UNSIGNED_INT_VEC2 = 0x8DC6;
var GL_UNSIGNED_INT_VEC3 = 0x8DC7;
var GL_UNSIGNED_INT_VEC4 = 0x8DC8;
var GL_FLOAT_MAT2 = 0x8B5A;
var GL_FLOAT_MAT3 = 0x8B5B;
var GL_FLOAT_MAT4 = 0x8B5C;
var GL_FLOAT_MAT2x3 = 0x8B65;
var GL_FLOAT_MAT2x4 = 0x8B66;
var GL_FLOAT_MAT3x2 = 0x8B67;
var GL_FLOAT_MAT3x4 = 0x8B68;
var GL_FLOAT_MAT4x2 = 0x8B69;
var GL_FLOAT_MAT4x3 = 0x8B6A; // Uniform table for std140

var UNIFORM_TYPES = (_UNIFORM_TYPES = {}, _defineProperty(_UNIFORM_TYPES, GL_FLOAT, [GL_FLOAT, 1]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_VEC2, [GL_FLOAT, 2]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_VEC3, [GL_FLOAT, 3]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_VEC4, [GL_FLOAT, 4]), _defineProperty(_UNIFORM_TYPES, GL_INT, [GL_INT, 1]), _defineProperty(_UNIFORM_TYPES, GL_INT_VEC2, [GL_INT, 2]), _defineProperty(_UNIFORM_TYPES, GL_INT_VEC3, [GL_INT, 3]), _defineProperty(_UNIFORM_TYPES, GL_INT_VEC4, [GL_INT, 4]), _defineProperty(_UNIFORM_TYPES, GL_UNSIGNED_INT, [GL_UNSIGNED_INT, 1]), _defineProperty(_UNIFORM_TYPES, GL_UNSIGNED_INT_VEC2, [GL_UNSIGNED_INT, 2]), _defineProperty(_UNIFORM_TYPES, GL_UNSIGNED_INT_VEC3, [GL_UNSIGNED_INT, 3]), _defineProperty(_UNIFORM_TYPES, GL_UNSIGNED_INT_VEC4, [GL_UNSIGNED_INT, 4]), _defineProperty(_UNIFORM_TYPES, GL_BOOL, [GL_FLOAT, 1]), _defineProperty(_UNIFORM_TYPES, GL_BOOL_VEC2, [GL_FLOAT, 2]), _defineProperty(_UNIFORM_TYPES, GL_BOOL_VEC3, [GL_FLOAT, 3]), _defineProperty(_UNIFORM_TYPES, GL_BOOL_VEC4, [GL_FLOAT, 4]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT2, [GL_FLOAT, 8]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT2x3, [GL_FLOAT, 8]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT2x4, [GL_FLOAT, 8]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT3, [GL_FLOAT, 12]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT3x2, [GL_FLOAT, 12]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT3x4, [GL_FLOAT, 12]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT4, [GL_FLOAT, 16]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT4x2, [GL_FLOAT, 16]), _defineProperty(_UNIFORM_TYPES, GL_FLOAT_MAT4x3, [GL_FLOAT, 16]), _UNIFORM_TYPES); // Std140 layout for uniforms

var UniformBufferLayout =
/*#__PURE__*/
function () {
  function UniformBufferLayout(layout) {
    var _typedArray;

    _classCallCheck(this, UniformBufferLayout);

    this.layout = {};
    this.size = 0; // Add layout (type, size and offset) definitions for each uniform in the layout

    for (var key in layout) {
      this._addUniform(key, layout[key]);
    } // Allocate three typed arrays pointing at same memory


    var data = new Float32Array(this.size);
    this.typedArray = (_typedArray = {}, _defineProperty(_typedArray, GL_FLOAT, data), _defineProperty(_typedArray, GL_INT, new Int32Array(data.buffer)), _defineProperty(_typedArray, GL_UNSIGNED_INT, new Uint32Array(data.buffer)), _typedArray);
  } // Get number of bytes needed for buffer allocation


  _createClass(UniformBufferLayout, [{
    key: "getBytes",
    value: function getBytes() {
      return this.size * 4;
    } // Get the current data as Float32Array, for bufferSubData

  }, {
    key: "getData",
    value: function getData() {
      return this.typedArray[GL_FLOAT];
    } // Get offset and data for one object (for bufferSubData)

  }, {
    key: "getSubData",
    value: function getSubData(index) {
      var data;
      var offset;

      if (index === undefined) {
        data = this.data;
        offset = 0;
      } else {
        var begin = this.offsets[index];
        var end = begin + this.sizes[index];
        data = this.data.subarray(begin, end);
        offset = begin * 4;
      }

      return {
        data: data,
        offset: offset
      };
    } // Set a map of values

  }, {
    key: "setUniforms",
    value: function setUniforms(values) {
      for (var key in values) {
        this._setValue(key, values[key]);
      }

      return this;
    }
  }, {
    key: "_setValue",
    value: function _setValue(key, value) {
      var layout = this.layout[key];
      assert(layout, 'UniformLayoutStd140 illegal argument');
      var typedArray = this.typedArray[layout.type];

      if (layout.size === 1) {
        // single value -> just set it
        typedArray[layout.offset] = value;
      } else {
        // vector/matrix -> copy the supplied (typed) array, starting from offset
        typedArray.set(value, layout.offset);
      }
    }
  }, {
    key: "_addUniform",
    value: function _addUniform(key, uniformType) {
      var definition = UNIFORM_TYPES[uniformType];
      assert(definition, ERR_ARGUMENT);

      var _definition = _slicedToArray(definition, 2),
          type = _definition[0],
          count = _definition[1]; // First, align (bump) current offset to an even multiple of current object (1, 2, 4)


      this.size = this._alignTo(this.size, count); // Use the aligned size as the offset of the current uniform.

      var offset = this.size; // Then, add our object's padded size ((1, 2, multiple of 4) to the current offset

      this.size += count;
      this.layout[key] = {
        type: type,
        size: count,
        offset: offset
      };
    } // Align offset to 1, 2 or 4 elements (4, 8 or 16 bytes)

  }, {
    key: "_alignTo",
    value: function _alignTo(size, count) {
      switch (count) {
        case 1:
          return size;
        // Pad upwards to even multiple of 2

        case 2:
          return size + size % 2;
        // Pad upwards to even multiple of 2

        default:
          return size + (4 - size % 4) % 4;
        // Pad upwards to even multiple of 4
      }
    }
  }]);

  return UniformBufferLayout;
}();

export { UniformBufferLayout as default };
//# sourceMappingURL=uniform-buffer-layout.js.map