"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _animationLoop = _interopRequireDefault(require("./animation-loop"));

var _webglContext = require("../webgl-context");

var _webglUtils = require("../webgl-utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var AnimationLoopProxy =
/*#__PURE__*/
function () {
  _createClass(AnimationLoopProxy, null, [{
    key: "createWorker",
    // Create the script for the rendering worker.
    // @param opts {object} - options to construct an AnimationLoop instance
    value: function createWorker(opts) {
      return function (self) {
        self.animationLoop = new _animationLoop.default(Object.assign({}, opts, {
          offScreen: true,
          // Prevent the animation loop from trying to access DOM properties
          useDevicePixels: false,
          autoResizeDrawingBuffer: false
        }));
        self.canvas = null;
        self.addEventListener('message', function (evt) {
          var animationLoop = self.animationLoop;

          switch (evt.data.command) {
            case 'start':
              self.canvas = evt.data.opts.canvas;
              animationLoop.start(evt.data.opts);
              break;

            case 'stop':
              animationLoop.stop();
              break;

            case 'resize':
              self.canvas.width = evt.data.width;
              self.canvas.height = evt.data.height;
              break;

            default:
          }
        });
      };
    }
    /*
     * @param {HTMLCanvasElement} canvas - if provided, width and height will be passed to context
     */

  }]);

  function AnimationLoopProxy(_ref) {
    var worker = _ref.worker,
        _ref$onInitialize = _ref.onInitialize,
        onInitialize = _ref$onInitialize === void 0 ? function () {} : _ref$onInitialize,
        _ref$onFinalize = _ref.onFinalize,
        onFinalize = _ref$onFinalize === void 0 ? function () {} : _ref$onFinalize,
        _ref$useDevicePixels = _ref.useDevicePixels,
        useDevicePixels = _ref$useDevicePixels === void 0 ? true : _ref$useDevicePixels,
        _ref$autoResizeDrawin = _ref.autoResizeDrawingBuffer,
        autoResizeDrawingBuffer = _ref$autoResizeDrawin === void 0 ? true : _ref$autoResizeDrawin;

    _classCallCheck(this, AnimationLoopProxy);

    this.props = {
      worker: worker,
      onInitialize: onInitialize,
      onFinalize: onFinalize,
      autoResizeDrawingBuffer: autoResizeDrawingBuffer,
      useDevicePixels: useDevicePixels
    }; // state

    this.canvas = null;
    this.width = null;
    this.height = null;
    this._stopped = true;
    this._animationFrameId = null;
    this._startPromise = null; // bind methods

    this._updateFrame = this._updateFrame.bind(this);
  }
  /* Public methods */
  // Starts a render loop if not already running


  _createClass(AnimationLoopProxy, [{
    key: "start",
    value: function start() {
      var _this = this;

      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this._stopped = false; // console.debug(`Starting ${this.constructor.name}`);

      if (!this._animationFrameId) {
        // Wait for start promise before rendering frame
        this._startPromise = (0, _webglContext.getPageLoadPromise)().then(function () {
          _this._createAndTransferCanvas(opts);

          return _this.props.onInitialize(_this);
        }).then(function () {
          if (!_this._stopped) {
            _this._animationFrameId = (0, _webglUtils.requestAnimationFrame)(_this._updateFrame);
          }
        });
      }

      return this;
    } // Stops a render loop if already running, finalizing

  }, {
    key: "stop",
    value: function stop() {
      if (this._animationFrameId) {
        (0, _webglUtils.cancelAnimationFrame)(this._animationFrameId);
        this._animationFrameId = null;
        this._stopped = true;
        this.props.onFinalize(this);
      }

      this.props.worker.postMessage({
        command: 'stop'
      });
      return this;
    } // PRIVATE METHODS

  }, {
    key: "_updateFrame",
    value: function _updateFrame() {
      this._resizeCanvasDrawingBuffer();

      this._animationFrameId = (0, _webglUtils.requestAnimationFrame)(this._updateFrame);
    }
  }, {
    key: "_createAndTransferCanvas",
    value: function _createAndTransferCanvas(opts) {
      // Create a canvas on the main thread
      var screenCanvas = (0, _webglContext.createCanvas)(opts); // Create an offscreen canvas controlling the main canvas

      if (!screenCanvas.transferControlToOffscreen) {
        onError('OffscreenCanvas is not available. Enable Experimental canvas features in chrome://flags'); // eslint-disable-line
      }

      var offscreenCanvas = screenCanvas.transferControlToOffscreen(); // Transfer the offscreen canvas to the worker

      this.props.worker.postMessage({
        command: 'start',
        opts: Object.assign({}, opts, {
          canvas: offscreenCanvas
        })
      }, [offscreenCanvas]); // store the main canvas on the local thread

      this.canvas = screenCanvas;
    }
  }, {
    key: "_resizeCanvasDrawingBuffer",
    value: function _resizeCanvasDrawingBuffer() {
      if (this.props.autoResizeDrawingBuffer) {
        var devicePixelRatio = this.props.useDevicePixels ? window.devicePixelRatio || 1 : 1;
        var width = this.canvas.clientWidth * devicePixelRatio;
        var height = this.canvas.clientHeight * devicePixelRatio;

        if (this.width !== width || this.height !== height) {
          this.width = width;
          this.height = height;
          this.props.worker.postMessage({
            command: 'resize',
            width: width,
            height: height
          });
        }
      }
    }
  }]);

  return AnimationLoopProxy;
}();

exports.default = AnimationLoopProxy;
//# sourceMappingURL=animation-loop-proxy.js.map