"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#define SHADER_NAME luma-frag-lighting-vs\n\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 texCoord1;\nattribute vec2 texCoord2;\nattribute vec2 texCoord3;\nattribute vec4 color;\n\nuniform mat4 worldMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 worldInverseTransposeMatrix;\n\nvarying vec2 vTexCoord1;\nvarying vec2 vTexCoord2;\nvarying vec2 vTexCoord3;\nvarying vec4 vTransformedNormal;\nvarying vec4 vPosition;\nvarying vec4 vColor;\n\n\nvoid main(void) {\n  vPosition = worldMatrix * vec4(position, 1.0);\n  vTransformedNormal = worldInverseTransposeMatrix * vec4(normal, 1.0);\n  vTexCoord1 = texCoord1;\n  vTexCoord2 = texCoord2;\n  vTexCoord3 = texCoord3;\n  vColor = color;\n  gl_Position = projectionMatrix * vPosition;\n}\n";
exports.default = _default;
//# sourceMappingURL=render-tex.vs.glsl.js.map