"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#define SHADER_NAME spec-map-vs\n\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec2 texCoords;\nattribute vec2 texCoord2;\nattribute vec2 texCoord3;\nattribute vec4 colors;\n\nuniform mat4 worldMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 worldInverseTransposeMatrix;\n\nvarying vec2 vTexCoord1;\nvarying vec2 vTexCoord2;\nvarying vec2 vTexCoord3;\nvarying vec4 vTransformedNormal;\nvarying vec4 vPosition;\nvarying vec4 vColor;\n\nvoid main(void) {\n  vPosition = worldMatrix * vec4(positions, 1.0);\n  vTransformedNormal = worldInverseTransposeMatrix * vec4(normals, 1.0);\n  vTexCoord1 = texCoords;\n  vTexCoord2 = texCoord2;\n  vTexCoord3 = texCoord3;\n  vColor = colors;\n  gl_Position = projectionMatrix * vPosition;\n}\n";
exports.default = _default;
//# sourceMappingURL=spec-map.vs.glsl.js.map