"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "isWebGL", {
  enumerable: true,
  get: function get() {
    return _webglChecks.isWebGL;
  }
});
Object.defineProperty(exports, "isWebGL2", {
  enumerable: true,
  get: function get() {
    return _webglChecks.isWebGL2;
  }
});
Object.defineProperty(exports, "getKeyValue", {
  enumerable: true,
  get: function get() {
    return _constantsToKeys.getKeyValue;
  }
});
Object.defineProperty(exports, "getKey", {
  enumerable: true,
  get: function get() {
    return _constantsToKeys.getKey;
  }
});
Object.defineProperty(exports, "createGLContext", {
  enumerable: true,
  get: function get() {
    return _context.createGLContext;
  }
});
Object.defineProperty(exports, "destroyGLContext", {
  enumerable: true,
  get: function get() {
    return _context.destroyGLContext;
  }
});
Object.defineProperty(exports, "resizeGLContext", {
  enumerable: true,
  get: function get() {
    return _context.resizeGLContext;
  }
});
Object.defineProperty(exports, "pollGLContext", {
  enumerable: true,
  get: function get() {
    return _context.pollGLContext;
  }
});
Object.defineProperty(exports, "setContextDefaults", {
  enumerable: true,
  get: function get() {
    return _context.setContextDefaults;
  }
});
Object.defineProperty(exports, "deleteGLContext", {
  enumerable: true,
  get: function get() {
    return _context.destroyGLContext;
  }
});
Object.defineProperty(exports, "pollContext", {
  enumerable: true,
  get: function get() {
    return _context.pollGLContext;
  }
});
Object.defineProperty(exports, "trackContextCreation", {
  enumerable: true,
  get: function get() {
    return _webglContext.trackContextCreation;
  }
});
Object.defineProperty(exports, "trackContextState", {
  enumerable: true,
  get: function get() {
    return _webglContext.trackContextState;
  }
});
Object.defineProperty(exports, "resetParameters", {
  enumerable: true,
  get: function get() {
    return _contextState.resetParameters;
  }
});
Object.defineProperty(exports, "getParameter", {
  enumerable: true,
  get: function get() {
    return _contextState.getParameter;
  }
});
Object.defineProperty(exports, "getParameters", {
  enumerable: true,
  get: function get() {
    return _contextState.getParameters;
  }
});
Object.defineProperty(exports, "setParameter", {
  enumerable: true,
  get: function get() {
    return _contextState.setParameter;
  }
});
Object.defineProperty(exports, "setParameters", {
  enumerable: true,
  get: function get() {
    return _contextState.setParameters;
  }
});
Object.defineProperty(exports, "withParameters", {
  enumerable: true,
  get: function get() {
    return _contextState.withParameters;
  }
});
Object.defineProperty(exports, "getModifiedParameters", {
  enumerable: true,
  get: function get() {
    return _contextState.getModifiedParameters;
  }
});
Object.defineProperty(exports, "getContextInfo", {
  enumerable: true,
  get: function get() {
    return _contextLimits.getContextInfo;
  }
});
Object.defineProperty(exports, "getGLContextInfo", {
  enumerable: true,
  get: function get() {
    return _contextLimits.getGLContextInfo;
  }
});
Object.defineProperty(exports, "getContextLimits", {
  enumerable: true,
  get: function get() {
    return _contextLimits.getContextLimits;
  }
});
Object.defineProperty(exports, "glGetDebugInfo", {
  enumerable: true,
  get: function get() {
    return _contextLimits.glGetDebugInfo;
  }
});
Object.defineProperty(exports, "FEATURES", {
  enumerable: true,
  get: function get() {
    return _contextFeatures.FEATURES;
  }
});
Object.defineProperty(exports, "hasFeature", {
  enumerable: true,
  get: function get() {
    return _contextFeatures.hasFeature;
  }
});
Object.defineProperty(exports, "hasFeatures", {
  enumerable: true,
  get: function get() {
    return _contextFeatures.hasFeatures;
  }
});
Object.defineProperty(exports, "getFeatures", {
  enumerable: true,
  get: function get() {
    return _contextFeatures.getFeatures;
  }
});
Object.defineProperty(exports, "canCompileGLGSExtension", {
  enumerable: true,
  get: function get() {
    return _contextFeatures.canCompileGLGSExtension;
  }
});
Object.defineProperty(exports, "makeDebugContext", {
  enumerable: true,
  get: function get() {
    return _debugContext.makeDebugContext;
  }
});
Object.defineProperty(exports, "Buffer", {
  enumerable: true,
  get: function get() {
    return _buffer.default;
  }
});
Object.defineProperty(exports, "Shader", {
  enumerable: true,
  get: function get() {
    return _shader.Shader;
  }
});
Object.defineProperty(exports, "VertexShader", {
  enumerable: true,
  get: function get() {
    return _shader.VertexShader;
  }
});
Object.defineProperty(exports, "FragmentShader", {
  enumerable: true,
  get: function get() {
    return _shader.FragmentShader;
  }
});
Object.defineProperty(exports, "Program", {
  enumerable: true,
  get: function get() {
    return _program.default;
  }
});
Object.defineProperty(exports, "Framebuffer", {
  enumerable: true,
  get: function get() {
    return _framebuffer.default;
  }
});
Object.defineProperty(exports, "FramebufferObject", {
  enumerable: true,
  get: function get() {
    return _framebuffer.default;
  }
});
Object.defineProperty(exports, "Renderbuffer", {
  enumerable: true,
  get: function get() {
    return _renderbuffer.default;
  }
});
Object.defineProperty(exports, "Texture2D", {
  enumerable: true,
  get: function get() {
    return _texture2d.default;
  }
});
Object.defineProperty(exports, "TextureCube", {
  enumerable: true,
  get: function get() {
    return _textureCube.default;
  }
});
Object.defineProperty(exports, "draw", {
  enumerable: true,
  get: function get() {
    return _draw.draw;
  }
});
Object.defineProperty(exports, "clear", {
  enumerable: true,
  get: function get() {
    return _clear.clear;
  }
});
Object.defineProperty(exports, "clearBuffer", {
  enumerable: true,
  get: function get() {
    return _clear.clearBuffer;
  }
});
Object.defineProperty(exports, "FenceSync", {
  enumerable: true,
  get: function get() {
    return _fenceSync.default;
  }
});
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function get() {
    return _query.default;
  }
});
Object.defineProperty(exports, "Sampler", {
  enumerable: true,
  get: function get() {
    return _sampler.default;
  }
});
Object.defineProperty(exports, "Texture3D", {
  enumerable: true,
  get: function get() {
    return _texture3d.default;
  }
});
Object.defineProperty(exports, "Texture2DArray", {
  enumerable: true,
  get: function get() {
    return _texture2dArray.default;
  }
});
Object.defineProperty(exports, "TransformFeedback", {
  enumerable: true,
  get: function get() {
    return _transformFeedback.default;
  }
});
Object.defineProperty(exports, "VertexArray", {
  enumerable: true,
  get: function get() {
    return _vertexArray.default;
  }
});
Object.defineProperty(exports, "UniformBufferLayout", {
  enumerable: true,
  get: function get() {
    return _uniformBufferLayout.default;
  }
});
Object.defineProperty(exports, "Model", {
  enumerable: true,
  get: function get() {
    return _model.default;
  }
});
Object.defineProperty(exports, "AnimationLoop", {
  enumerable: true,
  get: function get() {
    return _animationLoop.default;
  }
});
Object.defineProperty(exports, "AnimationLoopProxy", {
  enumerable: true,
  get: function get() {
    return _animationLoopProxy.default;
  }
});
Object.defineProperty(exports, "pickModels", {
  enumerable: true,
  get: function get() {
    return _pickModels.default;
  }
});
Object.defineProperty(exports, "encodePickingColor", {
  enumerable: true,
  get: function get() {
    return _pickingColors.encodePickingColor;
  }
});
Object.defineProperty(exports, "decodePickingColor", {
  enumerable: true,
  get: function get() {
    return _pickingColors.decodePickingColor;
  }
});
Object.defineProperty(exports, "getNullPickingColor", {
  enumerable: true,
  get: function get() {
    return _pickingColors.getNullPickingColor;
  }
});
Object.defineProperty(exports, "addEvents", {
  enumerable: true,
  get: function get() {
    return _events.addEvents;
  }
});
Object.defineProperty(exports, "Geometry", {
  enumerable: true,
  get: function get() {
    return _geometry.default;
  }
});
Object.defineProperty(exports, "ConeGeometry", {
  enumerable: true,
  get: function get() {
    return _coneGeometry.default;
  }
});
Object.defineProperty(exports, "CubeGeometry", {
  enumerable: true,
  get: function get() {
    return _cubeGeometry.default;
  }
});
Object.defineProperty(exports, "CylinderGeometry", {
  enumerable: true,
  get: function get() {
    return _cylinderGeometry.default;
  }
});
Object.defineProperty(exports, "IcoSphereGeometry", {
  enumerable: true,
  get: function get() {
    return _icoSphereGeometry.default;
  }
});
Object.defineProperty(exports, "PlaneGeometry", {
  enumerable: true,
  get: function get() {
    return _planeGeometry.default;
  }
});
Object.defineProperty(exports, "SphereGeometry", {
  enumerable: true,
  get: function get() {
    return _sphereGeometry.default;
  }
});
Object.defineProperty(exports, "TruncatedConeGeometry", {
  enumerable: true,
  get: function get() {
    return _truncatedConeGeometry.default;
  }
});
Object.defineProperty(exports, "Cone", {
  enumerable: true,
  get: function get() {
    return _cone.default;
  }
});
Object.defineProperty(exports, "Cube", {
  enumerable: true,
  get: function get() {
    return _cube.default;
  }
});
Object.defineProperty(exports, "Cylinder", {
  enumerable: true,
  get: function get() {
    return _cylinder.default;
  }
});
Object.defineProperty(exports, "IcoSphere", {
  enumerable: true,
  get: function get() {
    return _icoSphere.default;
  }
});
Object.defineProperty(exports, "Plane", {
  enumerable: true,
  get: function get() {
    return _plane.default;
  }
});
Object.defineProperty(exports, "Sphere", {
  enumerable: true,
  get: function get() {
    return _sphere.default;
  }
});
Object.defineProperty(exports, "TruncatedCone", {
  enumerable: true,
  get: function get() {
    return _truncatedCone.default;
  }
});
Object.defineProperty(exports, "ClipSpaceQuad", {
  enumerable: true,
  get: function get() {
    return _clipSpaceQuad.default;
  }
});
Object.defineProperty(exports, "setPathPrefix", {
  enumerable: true,
  get: function get() {
    return _io.setPathPrefix;
  }
});
Object.defineProperty(exports, "loadFile", {
  enumerable: true,
  get: function get() {
    return _io.loadFile;
  }
});
Object.defineProperty(exports, "loadImage", {
  enumerable: true,
  get: function get() {
    return _io.loadImage;
  }
});
Object.defineProperty(exports, "loadFiles", {
  enumerable: true,
  get: function get() {
    return _io.loadFiles;
  }
});
Object.defineProperty(exports, "loadImages", {
  enumerable: true,
  get: function get() {
    return _io.loadImages;
  }
});
Object.defineProperty(exports, "loadTextures", {
  enumerable: true,
  get: function get() {
    return _io.loadTextures;
  }
});
Object.defineProperty(exports, "loadProgram", {
  enumerable: true,
  get: function get() {
    return _io.loadProgram;
  }
});
Object.defineProperty(exports, "loadModel", {
  enumerable: true,
  get: function get() {
    return _io.loadModel;
  }
});
Object.defineProperty(exports, "parseModel", {
  enumerable: true,
  get: function get() {
    return _io.parseModel;
  }
});
Object.defineProperty(exports, "ShaderCache", {
  enumerable: true,
  get: function get() {
    return _shaderCache.default;
  }
});
Object.defineProperty(exports, "assembleShaders", {
  enumerable: true,
  get: function get() {
    return _assembleShaders.assembleShaders;
  }
});
Object.defineProperty(exports, "registerShaderModules", {
  enumerable: true,
  get: function get() {
    return _shaderModules.registerShaderModules;
  }
});
Object.defineProperty(exports, "setDefaultShaderModules", {
  enumerable: true,
  get: function get() {
    return _shaderModules.setDefaultShaderModules;
  }
});
Object.defineProperty(exports, "fp32", {
  enumerable: true,
  get: function get() {
    return _fp.default;
  }
});
Object.defineProperty(exports, "fp64", {
  enumerable: true,
  get: function get() {
    return _fp2.default;
  }
});
Object.defineProperty(exports, "project", {
  enumerable: true,
  get: function get() {
    return _project.default;
  }
});
Object.defineProperty(exports, "lighting", {
  enumerable: true,
  get: function get() {
    return _lighting.default;
  }
});
Object.defineProperty(exports, "dirlight", {
  enumerable: true,
  get: function get() {
    return _dirlight.default;
  }
});
Object.defineProperty(exports, "picking", {
  enumerable: true,
  get: function get() {
    return _picking.default;
  }
});
Object.defineProperty(exports, "diffuse", {
  enumerable: true,
  get: function get() {
    return _diffuse.default;
  }
});
Object.defineProperty(exports, "GL", {
  enumerable: true,
  get: function get() {
    return _constants.default;
  }
});
Object.defineProperty(exports, "glGet", {
  enumerable: true,
  get: function get() {
    return _glConstants.glGet;
  }
});
Object.defineProperty(exports, "glKey", {
  enumerable: true,
  get: function get() {
    return _glConstants.glKey;
  }
});
Object.defineProperty(exports, "radians", {
  enumerable: true,
  get: function get() {
    return _math.radians;
  }
});
Object.defineProperty(exports, "degrees", {
  enumerable: true,
  get: function get() {
    return _math.degrees;
  }
});
Object.defineProperty(exports, "Vector2", {
  enumerable: true,
  get: function get() {
    return _math.Vector2;
  }
});
Object.defineProperty(exports, "Vector3", {
  enumerable: true,
  get: function get() {
    return _math.Vector3;
  }
});
Object.defineProperty(exports, "Vector4", {
  enumerable: true,
  get: function get() {
    return _math.Vector4;
  }
});
Object.defineProperty(exports, "Matrix4", {
  enumerable: true,
  get: function get() {
    return _math.Matrix4;
  }
});
Object.defineProperty(exports, "Quaternion", {
  enumerable: true,
  get: function get() {
    return _math.Quaternion;
  }
});
Object.defineProperty(exports, "readPixels", {
  enumerable: true,
  get: function get() {
    return _functions.readPixels;
  }
});
exports.experimental = void 0;

var _webglChecks = require("./webgl-utils/webgl-checks");

var _constantsToKeys = require("./webgl-utils/constants-to-keys");

var _context = require("./webgl-context/context");

var _webglContext = require("./webgl-context");

var _contextState = require("./webgl-context/context-state");

var _contextLimits = require("./webgl-context/context-limits");

var _contextFeatures = require("./webgl-context/context-features");

var _debugContext = require("./webgl-context/debug-context");

var _attribute = _interopRequireDefault(require("./webgl/attribute"));

var _buffer = _interopRequireDefault(require("./webgl/buffer"));

var _shader = require("./webgl/shader");

var _program = _interopRequireDefault(require("./webgl/program"));

var _framebuffer = _interopRequireDefault(require("./webgl/framebuffer"));

var _renderbuffer = _interopRequireDefault(require("./webgl/renderbuffer"));

var _texture2d = _interopRequireDefault(require("./webgl/texture-2d"));

var _textureCube = _interopRequireDefault(require("./webgl/texture-cube"));

var _draw = require("./webgl/draw");

var _clear = require("./webgl/clear");

var _fenceSync = _interopRequireDefault(require("./webgl/fence-sync"));

var _query = _interopRequireDefault(require("./webgl/query"));

var _sampler = _interopRequireDefault(require("./webgl/sampler"));

var _texture3d = _interopRequireDefault(require("./webgl/texture-3d"));

var _texture2dArray = _interopRequireDefault(require("./webgl/texture-2d-array"));

var _transformFeedback = _interopRequireDefault(require("./webgl/transform-feedback"));

var _vertexArray = _interopRequireDefault(require("./webgl/vertex-array"));

var _uniformBufferLayout = _interopRequireDefault(require("./webgl/uniform-buffer-layout"));

var _model = _interopRequireDefault(require("./core/model"));

var _animationLoop = _interopRequireDefault(require("./core/animation-loop"));

var _animationLoopProxy = _interopRequireDefault(require("./core/animation-loop-proxy"));

var _pickModels = _interopRequireDefault(require("./core/pick-models"));

var _pickingColors = require("./core/picking-colors");

var _events = require("./packages/events");

var _geometry = _interopRequireDefault(require("./geometry/geometry"));

var _coneGeometry = _interopRequireDefault(require("./geometry/cone-geometry"));

var _cubeGeometry = _interopRequireDefault(require("./geometry/cube-geometry"));

var _cylinderGeometry = _interopRequireDefault(require("./geometry/cylinder-geometry"));

var _icoSphereGeometry = _interopRequireDefault(require("./geometry/ico-sphere-geometry"));

var _planeGeometry = _interopRequireDefault(require("./geometry/plane-geometry"));

var _sphereGeometry = _interopRequireDefault(require("./geometry/sphere-geometry"));

var _truncatedConeGeometry = _interopRequireDefault(require("./geometry/truncated-cone-geometry"));

var _cone = _interopRequireDefault(require("./models/cone"));

var _cube = _interopRequireDefault(require("./models/cube"));

var _cylinder = _interopRequireDefault(require("./models/cylinder"));

var _icoSphere = _interopRequireDefault(require("./models/ico-sphere"));

var _plane = _interopRequireDefault(require("./models/plane"));

var _sphere = _interopRequireDefault(require("./models/sphere"));

var _truncatedCone = _interopRequireDefault(require("./models/truncated-cone"));

var _clipSpaceQuad = _interopRequireDefault(require("./models/clip-space-quad"));

var _io = require("./io");

var _shaderCache = _interopRequireDefault(require("./shadertools/lib/shader-cache"));

var _assembleShaders = require("./shadertools/lib/assemble-shaders");

var _shaderModules = require("./shadertools/lib/shader-modules");

var _fp = _interopRequireDefault(require("./shadertools/modules/fp32/fp32"));

var _fp2 = _interopRequireDefault(require("./shadertools/modules/fp64/fp64"));

var _project = _interopRequireDefault(require("./shadertools/modules/project/project"));

var _lighting = _interopRequireDefault(require("./shadertools/modules/lighting/lighting"));

var _dirlight = _interopRequireDefault(require("./shadertools/modules/dirlight/dirlight"));

var _picking = _interopRequireDefault(require("./shadertools/modules/picking/picking"));

var _diffuse = _interopRequireDefault(require("./shadertools/modules/diffuse/diffuse"));

var _transform = _interopRequireDefault(require("./core/experimental/transform"));

var _constants = _interopRequireDefault(require("./constants"));

var _glConstants = require("./deprecated/gl-constants");

var _math = require("math.gl");

var _functions = require("./webgl/functions");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Export core modules for luma.gl
// Initialize any global state
require('./init'); // WebGL


var experimental = {
  clearBuffer: _clear.clearBuffer,
  Transform: _transform.default,
  Attribute: _attribute.default
}; // DEPRECATED EXPORTS IN v5.3

exports.experimental = experimental;
//# sourceMappingURL=index.js.map