"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#ifdef GL_ES\nprecision highp float;\n#endif\n\n#define LIGHT_MAX 4\n\nvarying vec3 lighting_vLightWeighting;\n\nvec4 lighting_apply(vec4 color) {\n  // set color from texture\n  return vec4(color.rgb * lighting_vLightWeighting, color.a);\n}\n\n// spec-map.fs\n\nuniform mat4 viewMatrix;\n\n\nvarying vec4 lighting_vColor;\nvarying vec4 lighting_vTransformedNormal;\nvarying vec4 lighting_vPosition;\n\nuniform float shininess;\nuniform bool enableSpecularMap;\nuniform bool enableLights;\n\nuniform vec3 ambientColor;\nuniform vec3 directionalColor;\nuniform vec3 lightingDirection;\n\nuniform vec3 lighting_uPointLocation[LIGHT_MAX];\nuniform vec3 lighting_uPointColor[LIGHT_MAX];\nuniform float lighting_uPointSpecularEnable[LIGHT_MAX];\nuniform vec3 lighting_uPointSpecularColor[LIGHT_MAX];\nuniform int numberPoints;\n\n\nvec3 lighting__calculate_light_weighting() {\n\treturn lighting__calculate_light_weighting(shininess);\n}\n\nvec3 lighting__calculate_light_weighting(shininess) {\n  vec3 normal = vTransformedNormal.xyz;\n  vec3 eyeDirection = normalize(-vPosition.xyz);\n\n  vec3 specularLight = vec3(0., 0., 0.);\n  vec3 diffuseLight = vec3(0., 0., 0.);\n\n  for (int i = 0; i < LIGHT_MAX; i++) {\n    if (i < numberPoints) {\n      vec3 transformedPointLocation = (viewMatrix * vec4(lighting_uPointLocation[i], 1.0)).xyz;\n      vec3 lightDirection = normalize(transformedPointLocation - vPosition.xyz);\n\n      if (lighting_uPointSpecularEnable > 0.) {\n        vec3 reflectionDirection = reflect(-lightDirection, normal);\n        float specularLightWeighting =\n          pow(max(dot(reflectionDirection, eyeDirection), 0.0), shininessVal);\n        specularLight += specularLightWeighting * lighting_uPointSpecularColor[i];\n      }\n\n      float diffuseLightWeighting = max(dot(normal, lightDirection), 0.0);\n      diffuseLight += diffuseLightWeighting * lighting_uPointColor[i];\n    } else {\n      break;\n    }\n  }\n\n  return ambientColor + diffuseLight + specularLight;\n}\n\nvoid lighting_filterColor(fragmentColor) {\n  if (!lighting_enable) {\n  \treturn fragmentColor;\n  } else {\n  \tvec3 lightWeighting = lighting__calculate_light_weighting();\n  \treturn vec4(fragmentColor.rgb * lightWeighting, fragmentColor.a);\n  }\n}\n\n// render-tex.fs\n\nuniform vec3 material_uAmbientColor;\nuniform vec3 material_uDiffuseColor;\nuniform vec3 material_uSpecularColor;\nuniform vec3 material_uEmissiveColor;\n\nuniform bool hasTexture1;\nuniform sampler2D sampler1;\n\nuniform mat4 viewMatrix;\n\nvoid apply_lighting(color) {\n  vec3 ambientLightWeighting = ambientColor;\n\n  vec3 normal = vTransformedNormal.xyz;\n  vec3 eyeDirection = normalize(-vPosition.xyz);\n\n  vec3 specularLight = vec3(0.0, 0.0, 0.0);\n  vec3 diffuseLight = vec3(0.0, 0.0, 0.0);\n\n  for (int i = 0; i < LIGHT_MAX; i++) {\n    if (i < numberPoints) {\n      vec3 transformedPointLocation = (viewMatrix * vec4(pointLocation[i], 1.0)).xyz;\n      vec3 lightDirection = normalize(transformedPointLocation - vPosition.xyz);\n\n      if (enableSpecularHighlights) {\n        vec3 reflectionDirection = reflect(-lightDirection, normal);\n        float specularLightWeighting =\n          pow(max(dot(reflectionDirection, eyeDirection), 0.0), shininess);\n        specularLight += specularLightWeighting * pointSpecularColor[i];\n      }\n\n      float diffuseLightWeighting = max(dot(normal, lightDirection), 0.0);\n      diffuseLight += diffuseLightWeighting * pointColor[i];\n    } else {\n        break;\n    }\n  }\n\n  vec3 matAmbientColor = material_uAmbientColor * color.rgb;\n  vec3 matDiffuseColor = material_uDiffuseColor * color.rgb;\n  vec3 matSpecularColor = material_uSpecularColor * color.rgb;\n  vec3 matEmissiveColor = material_uEmissiveColor * color.rgb;\n  gl_FragColor = vec4(\n    matAmbientColor * ambientLightWeighting\n    + matDiffuseColor * diffuseLightWeighting\n    + matSpecularColor * specularLightWeighting\n    + matEmissiveColor,\n    color.a\n  );\n}\n\n/// frag-lighting\n\n  vec3 lightWeighting;\n  if (!enableLights) {\n    lightWeighting = vec3(1.0, 1.0, 1.0);\n  } else {\n    vec3 lightDirection;\n    float specularLightWeighting = 0.0;\n    float diffuseLightWeighting = 0.0;\n    vec3  specularLight = vec3(0.0, 0.0, 0.0);\n    vec3  diffuseLight = vec3(0.0, 0.0, 0.0);\n\n    vec3 transformedPointLocation;\n    vec3 normal = vTransformedNormal.xyz;\n\n    vec3 eyeDirection = normalize(-vPosition.xyz);\n    vec3 reflectionDirection;\n\n    vec3 pointWeight = vec3(0.0, 0.0, 0.0);\n\n    for (int i = 0; i < LIGHT_MAX; i++) {\n      if (i < numberPoints) {\n        transformedPointLocation = (viewMatrix * vec4(pointLocation[i], 1.0)).xyz;\n        lightDirection = normalize(transformedPointLocation - vPosition.xyz);\n\n        if (enableSpecular[i] > 0.0) {\n          reflectionDirection = reflect(-lightDirection, normal);\n          specularLightWeighting = pow(max(dot(reflectionDirection, eyeDirection), 0.0), shininess);\n          specularLight += specularLightWeighting * pointSpecularColor[i];\n        }\n\n        diffuseLightWeighting = max(dot(normal, lightDirection), 0.0);\n        diffuseLight += diffuseLightWeighting * pointColor[i];\n      } else {\n        break;\n      }\n    }\n\n    lightWeighting = ambientColor + diffuseLight + specularLight;\n  }\n\n// reflection / refraction configs\nuniform float reflection;\nuniform float refraction;\n\n///\n  // has cube texture then apply reflection\n  // if (hasTextureCube1) {\n  //   vec3 nReflection = normalize(vReflection);\n  //   vec3 reflectionValue;\n  //   if (refraction > 0.0) {\n  //    reflectionValue = refract(nReflection, vNormal.xyz, refraction);\n  //   } else {\n  //    reflectionValue = -reflect(nReflection, vNormal.xyz);\n  //   }\n\n  //   // TODO(nico): check whether this is right.\n  //   vec4 cubeColor = textureCube(samplerCube1,\n  //       vec3(-reflectionValue.x, -reflectionValue.y, reflectionValue.z));\n  //   gl_FragColor = vec4(mix(gl_FragColor.xyz, cubeColor.xyz, reflection), 1.0);\n  // }\n";
exports.default = _default;
//# sourceMappingURL=lighting-fragment.glsl.js.map