"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextLimits = getContextLimits;
exports.getGLContextInfo = getGLContextInfo;
exports.getGLContextInfo2 = getGLContextInfo2;
exports.getContextInfo = getContextInfo;
exports.glGetDebugInfo = glGetDebugInfo;
exports.TEST_EXPORTS = void 0;

var _constants = _interopRequireDefault(require("../constants"));

var _webglUtils = require("../webgl-utils");

var _WEBGL_LIMITS;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var WEBGL_LIMITS = (_WEBGL_LIMITS = {}, _defineProperty(_WEBGL_LIMITS, _constants.default.ALIASED_LINE_WIDTH_RANGE, {
  gl1: new Float32Array([1, 1])
}), _defineProperty(_WEBGL_LIMITS, _constants.default.ALIASED_POINT_SIZE_RANGE, {
  gl1: new Float32Array([1, 1])
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_TEXTURE_SIZE, {
  gl1: 64,
  gl2: 2048
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_CUBE_MAP_TEXTURE_SIZE, {
  gl1: 16
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_TEXTURE_IMAGE_UNITS, {
  gl1: 8
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_COMBINED_TEXTURE_IMAGE_UNITS, {
  gl1: 8
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VERTEX_TEXTURE_IMAGE_UNITS, {
  gl1: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_RENDERBUFFER_SIZE, {
  gl1: 1
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VARYING_VECTORS, {
  gl1: 8
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VERTEX_ATTRIBS, {
  gl1: 8
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VERTEX_UNIFORM_VECTORS, {
  gl1: 128
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_FRAGMENT_UNIFORM_VECTORS, {
  gl1: 16
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VIEWPORT_DIMS, {
  gl1: new Int32Array([0, 0])
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_3D_TEXTURE_SIZE, {
  gl1: 0,
  gl2: 256
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_ARRAY_TEXTURE_LAYERS, {
  gl1: 0,
  gl2: 256
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_CLIENT_WAIT_TIMEOUT_WEBGL, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_COLOR_ATTACHMENTS, {
  gl1: 0,
  gl2: 4
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_COMBINED_UNIFORM_BLOCKS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_DRAW_BUFFERS, {
  gl1: 0,
  gl2: 4
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_ELEMENT_INDEX, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_ELEMENTS_INDICES, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_ELEMENTS_VERTICES, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_FRAGMENT_INPUT_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_FRAGMENT_UNIFORM_BLOCKS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_FRAGMENT_UNIFORM_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_SAMPLES, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_SERVER_WAIT_TIMEOUT, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_TEXTURE_LOD_BIAS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_UNIFORM_BLOCK_SIZE, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_UNIFORM_BUFFER_BINDINGS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VARYING_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VERTEX_OUTPUT_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VERTEX_UNIFORM_BLOCKS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_VERTEX_UNIFORM_COMPONENTS, {
  gl1: 0,
  gl2: 0
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MIN_PROGRAM_TEXEL_OFFSET, {
  gl1: 0,
  gl2: -8,
  negative: true
}), _defineProperty(_WEBGL_LIMITS, _constants.default.MAX_PROGRAM_TEXEL_OFFSET, {
  gl1: 0,
  gl2: 7
}), _defineProperty(_WEBGL_LIMITS, _constants.default.UNIFORM_BUFFER_OFFSET_ALIGNMENT, {
  gl1: 0,
  gl2: 0 // GLint

}), _WEBGL_LIMITS);

function getContextLimits(gl) {
  gl.luma = gl.luma || {};

  if (!gl.luma.limits) {
    gl.luma.limits = {};
    gl.luma.webgl1MinLimits = {};
    gl.luma.webgl2MinLimits = {};
    var isWebgl2 = (0, _webglUtils.isWebGL2)(gl); // WEBGL limits

    for (var parameter in WEBGL_LIMITS) {
      var limit = WEBGL_LIMITS[parameter];
      var webgl1MinLimit = limit.gl1;
      var webgl2MinLimit = 'gl2' in limit ? limit.gl2 : limit.gl1;
      var minLimit = isWebgl2 ? webgl2MinLimit : webgl1MinLimit; // Check if we can query for this limit

      var limitNotAvailable = 'gl2' in limit && !isWebgl2 || 'extension' in limit && !gl.getExtension(limit.extension);
      var value = limitNotAvailable ? minLimit : gl.getParameter(parameter);
      gl.luma.limits[parameter] = value;
      gl.luma.webgl1MinLimits[parameter] = webgl1MinLimit;
      gl.luma.webgl2MinLimits[parameter] = webgl2MinLimit;
    }
  }

  return gl.luma.limits;
}

function getGLContextInfo(gl) {
  gl.luma = gl.luma || {};

  if (!gl.luma.info) {
    var _gl$luma$info;

    var info = gl.getExtension('WEBGL_debug_renderer_info');
    gl.luma.info = (_gl$luma$info = {}, _defineProperty(_gl$luma$info, _constants.default.VENDOR, gl.getParameter(_constants.default.VENDOR)), _defineProperty(_gl$luma$info, _constants.default.RENDERER, gl.getParameter(_constants.default.RENDERER)), _defineProperty(_gl$luma$info, _constants.default.UNMASKED_VENDOR_WEBGL, gl.getParameter(info && info.UNMASKED_VENDOR_WEBGL || _constants.default.VENDOR)), _defineProperty(_gl$luma$info, _constants.default.UNMASKED_RENDERER_WEBGL, gl.getParameter(info && info.UNMASKED_RENDERER_WEBGL || _constants.default.RENDERER)), _defineProperty(_gl$luma$info, _constants.default.VERSION, gl.getParameter(_constants.default.VERSION)), _defineProperty(_gl$luma$info, _constants.default.SHADING_LANGUAGE_VERSION, gl.getParameter(_constants.default.SHADING_LANGUAGE_VERSION)), _gl$luma$info);
  }

  return gl.luma.info;
}

var GL_UNMASKED_VENDOR_WEBGL = 0x9245; // vendor string of the graphics driver.

var GL_UNMASKED_RENDERER_WEBGL = 0x9246; // renderer string of the graphics driver.

function getGLContextInfo2(gl) {
  var vendorMasked = gl.getParameter(_constants.default.VENDOR);
  var rendererMasked = gl.getParameter(_constants.default.RENDERER);
  var ext = gl.getExtension('WEBGL_debug_renderer_info');
  var vendorUnmasked = ext && gl.getParameter(ext.UNMASKED_VENDOR_WEBGL || _constants.default.VENDOR);
  var rendererUnmasked = ext && gl.getParameter(ext.UNMASKED_RENDERER_WEBGL || _constants.default.RENDERER);
  return {
    vendor: vendorUnmasked || vendorMasked,
    renderer: rendererUnmasked || rendererMasked,
    vendorMasked: vendorMasked,
    rendererMasked: rendererMasked,
    version: gl.getParameter(_constants.default.VERSION),
    shadingLanguageVersion: gl.getParameter(_constants.default.SHADING_LANGUAGE_VERSION)
  };
}

function getContextInfo(gl) {
  var limits = getContextLimits(gl);
  var info = getGLContextInfo(gl);
  return {
    // basic information
    vendor: info[GL_UNMASKED_VENDOR_WEBGL] || info[_constants.default.VENDOR],
    renderer: info[GL_UNMASKED_RENDERER_WEBGL] || info[_constants.default.RENDERER],
    version: info[_constants.default.VERSION],
    shadingLanguageVersion: info[_constants.default.SHADING_LANGUAGE_VERSION],
    // info, caps and limits
    info: info,
    limits: limits,
    webgl1MinLimits: gl.luma.webgl1MinLimits,
    webgl2MinLimits: gl.luma.webgl2MinLimits
  };
} // DEBUG INFO

/**
 * Provides strings identifying the GPU vendor and driver.
 * https://www.khronos.org/registry/webgl/extensions/WEBGL_debug_renderer_info/
 * @param {WebGLRenderingContext} gl - context
 * @return {Object} - 'vendor' and 'renderer' string fields.
 */


function glGetDebugInfo(gl) {
  return getGLContextInfo2(gl); // const info = gl.getExtension('WEBGL_debug_renderer_info');
  // // We can't determine if 'WEBGL_debug_renderer_info' is supported by
  // // checking whether info is null here. Firefox doesn't follow the
  // // specs by returning null for unsupported extension. Instead,
  // // it returns an object without GL_UNMASKED_VENDOR_WEBGL and GL_UNMASKED_RENDERER_WEBGL.
  // return {
  //   vendor: (info && info.UNMASKED_VENDOR_WEBGL) ?
  //     gl.getParameter(info.UNMASKED_VENDOR_WEBGL) : 'unknown',
  //   renderer: (info && info.UNMASKED_RENDERER_WEBGL) ?
  //     gl.getParameter(info.UNMASKED_RENDERER_WEBGL) : 'unknown'
  // };
}

var TEST_EXPORTS = {
  WEBGL_LIMITS: WEBGL_LIMITS
};
exports.TEST_EXPORTS = TEST_EXPORTS;
//# sourceMappingURL=context-limits.js.map