"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHeadlessContext = createHeadlessContext;
exports.isWebglAvailable = exports.headlessGL = void 0;

var _isBrowser = _interopRequireDefault(require("../utils/is-browser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable quotes, no-console */

/* global console */
var ERR_HEADLESSGL_LOAD = "WebGL not available in Node.js, install using \"npm install gl\".";
var ERR_HEADLESSGL_NOT_AVAILABLE = 'Failed to create WebGL context in Node.js, headless gl not available';
var ERR_HEADLESSGL_FAILED = 'Failed to create WebGL context in Node.js, headless gl returned null';
var headlessGL = null;
exports.headlessGL = headlessGL;

if (!_isBrowser.default) {
  try {
    exports.headlessGL = headlessGL = module.require('gl');
  } catch (error) {
    console.error();
    console.error("".concat(ERR_HEADLESSGL_LOAD, "\n").concat(error.message));
  }
}

var isWebglAvailable = _isBrowser.default || headlessGL; // Create headless gl context (for running under Node.js)

exports.isWebglAvailable = isWebglAvailable;

function createHeadlessContext(_ref) {
  var width = _ref.width,
      height = _ref.height,
      opts = _ref.opts,
      onError = _ref.onError;
  var webgl1 = opts.webgl1,
      webgl2 = opts.webgl2;

  if (webgl2 && !webgl1) {
    return onError('headless-gl does not support WebGL2');
  }

  if (!headlessGL) {
    return onError(ERR_HEADLESSGL_NOT_AVAILABLE);
  }

  var gl = headlessGL(width, height, opts);

  if (!gl) {
    return onError(ERR_HEADLESSGL_FAILED);
  }

  return gl;
}
//# sourceMappingURL=create-headless-context.js.map