"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Image", {
  enumerable: true,
  get: function get() {
    return _webglTypes.Image;
  }
});
Object.defineProperty(exports, "WebGLRenderingContext", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLRenderingContext;
  }
});
Object.defineProperty(exports, "WebGLProgram", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLProgram;
  }
});
Object.defineProperty(exports, "WebGLShader", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLShader;
  }
});
Object.defineProperty(exports, "WebGLBuffer", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLBuffer;
  }
});
Object.defineProperty(exports, "WebGLFramebuffer", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLFramebuffer;
  }
});
Object.defineProperty(exports, "WebGLRenderbuffer", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLRenderbuffer;
  }
});
Object.defineProperty(exports, "WebGLTexture", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLTexture;
  }
});
Object.defineProperty(exports, "WebGLUniformLocation", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLUniformLocation;
  }
});
Object.defineProperty(exports, "WebGLActiveInfo", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLActiveInfo;
  }
});
Object.defineProperty(exports, "WebGLShaderPrecisionFormat", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGLShaderPrecisionFormat;
  }
});
Object.defineProperty(exports, "WebGL2RenderingContext", {
  enumerable: true,
  get: function get() {
    return _webglTypes.WebGL2RenderingContext;
  }
});
Object.defineProperty(exports, "webGLTypesAvailable", {
  enumerable: true,
  get: function get() {
    return _webglTypes.webGLTypesAvailable;
  }
});
Object.defineProperty(exports, "isWebGL", {
  enumerable: true,
  get: function get() {
    return _webglChecks.isWebGL;
  }
});
Object.defineProperty(exports, "isWebGL2", {
  enumerable: true,
  get: function get() {
    return _webglChecks.isWebGL2;
  }
});
Object.defineProperty(exports, "assertWebGLContext", {
  enumerable: true,
  get: function get() {
    return _webglChecks.assertWebGLContext;
  }
});
Object.defineProperty(exports, "assertWebGL2Context", {
  enumerable: true,
  get: function get() {
    return _webglChecks.assertWebGL2Context;
  }
});
Object.defineProperty(exports, "requestAnimationFrame", {
  enumerable: true,
  get: function get() {
    return _requestAnimationFrame.requestAnimationFrame;
  }
});
Object.defineProperty(exports, "cancelAnimationFrame", {
  enumerable: true,
  get: function get() {
    return _requestAnimationFrame.cancelAnimationFrame;
  }
});
Object.defineProperty(exports, "formatGLSLCompilerError", {
  enumerable: true,
  get: function get() {
    return _formatGlslError.default;
  }
});
Object.defineProperty(exports, "parseGLSLCompilerError", {
  enumerable: true,
  get: function get() {
    return _formatGlslError.parseGLSLCompilerError;
  }
});
Object.defineProperty(exports, "getShaderName", {
  enumerable: true,
  get: function get() {
    return _getShaderName.default;
  }
});
Object.defineProperty(exports, "getGLTypeFromTypedArray", {
  enumerable: true,
  get: function get() {
    return _typedArrayUtils.getGLTypeFromTypedArray;
  }
});
Object.defineProperty(exports, "getTypedArrayFromGLType", {
  enumerable: true,
  get: function get() {
    return _typedArrayUtils.getTypedArrayFromGLType;
  }
});
Object.defineProperty(exports, "flipRows", {
  enumerable: true,
  get: function get() {
    return _typedArrayUtils.flipRows;
  }
});
Object.defineProperty(exports, "scalePixels", {
  enumerable: true,
  get: function get() {
    return _typedArrayUtils.scalePixels;
  }
});
Object.defineProperty(exports, "getKeyValue", {
  enumerable: true,
  get: function get() {
    return _constantsToKeys.getKeyValue;
  }
});
Object.defineProperty(exports, "getKey", {
  enumerable: true,
  get: function get() {
    return _constantsToKeys.getKey;
  }
});
Object.defineProperty(exports, "getKeyType", {
  enumerable: true,
  get: function get() {
    return _constantsToKeys.getKeyType;
  }
});
Object.defineProperty(exports, "GL", {
  enumerable: true,
  get: function get() {
    return _constants.default;
  }
});

var _webglTypes = require("./webgl-types");

var _webglChecks = require("./webgl-checks");

var _requestAnimationFrame = require("./request-animation-frame");

var _formatGlslError = _interopRequireWildcard(require("./format-glsl-error"));

var _getShaderName = _interopRequireDefault(require("./get-shader-name"));

var _typedArrayUtils = require("./typed-array-utils");

var _constantsToKeys = require("../webgl-utils/constants-to-keys");

var _constants = _interopRequireDefault(require("../constants"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }
//# sourceMappingURL=index.js.map