"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = _interopRequireDefault(require("../constants"));

var _webglUtils = require("../webgl-utils");

var _resource = _interopRequireDefault(require("./resource"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var Sampler =
/*#__PURE__*/
function (_Resource) {
  _inherits(Sampler, _Resource);

  _createClass(Sampler, null, [{
    key: "isSupported",
    value: function isSupported(gl) {
      return (0, _webglUtils.isWebGL2)(gl);
    }
  }, {
    key: "isHandle",
    value: function isHandle(handle) {
      return this.gl.isSampler(this.handle);
    }
  }]);

  function Sampler(gl, opts) {
    var _this;

    _classCallCheck(this, Sampler);

    (0, _webglUtils.assertWebGL2Context)(gl);
    _this = _possibleConstructorReturn(this, (Sampler.__proto__ || Object.getPrototypeOf(Sampler)).call(this, gl, opts));
    Object.seal(_assertThisInitialized(_this));
    return _this;
  }
  /**
   * Bind to the same texture unit as a texture to control sampling for that texture
   * @param {GLuint} unit - texture unit index
   * @return {Sampler} - returns self to enable chaining
   */


  _createClass(Sampler, [{
    key: "bind",
    value: function bind(unit) {
      this.gl.bindSampler(unit, this.handle);
      return this;
    }
    /**
     * Bind to the same texture unit as a texture to control sampling for that texture
     * @param {GLuint} unit - texture unit index
     * @return {Sampler} - returns self to enable chaining
     */

  }, {
    key: "unbind",
    value: function unbind(unit) {
      this.gl.bindSampler(unit, null);
      return this;
    } // RESOURCE METHODS

  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createSampler();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteSampler(this.handle);
    }
  }, {
    key: "_getParameter",
    value: function _getParameter(pname) {
      var value = this.gl.getSamplerParameter(this.handle, pname);
      return value;
    }
  }, {
    key: "_setParameter",
    value: function _setParameter(pname, param) {
      // Apparently there are some conversion integer/float rules that made
      // the WebGL committe expose two parameter setting functions in JavaScript.
      // For now, pick the float version for parameters specified as GLfloat.
      switch (pname) {
        case _constants.default.TEXTURE_MIN_LOD:
        case _constants.default.TEXTURE_MAX_LOD:
          this.gl.samplerParameterf(this.handle, pname, param);
          break;

        default:
          this.gl.samplerParameteri(this.handle, pname, param);
          break;
      }

      return this;
    }
  }]);

  return Sampler;
}(_resource.default);

exports.default = Sampler;
//# sourceMappingURL=sampler.js.map