"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FragmentShader = exports.VertexShader = exports.Shader = void 0;

var _resource = _interopRequireDefault(require("./resource"));

var _webglUtils = require("../webgl-utils");

var _utils = require("../utils");

var _assert = _interopRequireDefault(require("../utils/assert"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ERR_SOURCE = 'Shader: GLSL source code must be a JavaScript string';
var GL_FRAGMENT_SHADER = 0x8B30;
var GL_VERTEX_SHADER = 0x8B31;
var GL_COMPILE_STATUS = 0x8B81;
var GL_SHADER_TYPE = 0x8B4F; // For now this is an internal class

var Shader =
/*#__PURE__*/
function (_Resource) {
  _inherits(Shader, _Resource);

  _createClass(Shader, null, [{
    key: "getTypeName",
    value: function getTypeName(shaderType) {
      switch (shaderType) {
        case GL_VERTEX_SHADER:
          return 'vertex-shader';

        case GL_FRAGMENT_SHADER:
          return 'fragment-shader';

        default:
          (0, _assert.default)(false);
          return 'unknown';
      }
    }
    /* eslint-disable max-statements */

  }]);

  function Shader(gl, source, shaderType) {
    var _this;

    _classCallCheck(this, Shader);

    (0, _webglUtils.assertWebGLContext)(gl);
    (0, _assert.default)(typeof source === 'string', ERR_SOURCE);
    _this = _possibleConstructorReturn(this, (Shader.__proto__ || Object.getPrototypeOf(Shader)).call(this, gl, {
      id: (0, _webglUtils.getShaderName)(source) || (0, _utils.uid)(Shader.getTypeName(shaderType))
    }));
    _this.shaderType = shaderType;
    _this.source = source;
    _this.opts.source = source;

    _this.initialize(_this.opts);

    return _this;
  }

  _createClass(Shader, [{
    key: "initialize",
    value: function initialize(_ref) {
      var source = _ref.source;
      var shaderName = (0, _webglUtils.getShaderName)(source);

      if (shaderName) {
        this.id = (0, _utils.uid)(shaderName);
      }

      this._compile(source);

      this.opts.source = source;
    } // Accessors

  }, {
    key: "getParameter",
    value: function getParameter(pname) {
      return this.gl.getShaderParameter(this.handle, pname);
    }
  }, {
    key: "toString",
    value: function toString() {
      return "".concat(this.getTypeName(this.shaderType), ":").concat(this.id);
    }
  }, {
    key: "getName",
    value: function getName() {
      return (0, _webglUtils.getShaderName)(this.opts.source) || 'unnamed-shader';
    }
  }, {
    key: "getSource",
    value: function getSource() {
      return this.gl.getShaderSource(this.handle);
    } // Debug method - Returns translated source if available

  }, {
    key: "getTranslatedSource",
    value: function getTranslatedSource() {
      var extension = this.gl.getExtension('WEBGL_debug_shaders');
      return extension ? extension.getTranslatedShaderSource(this.handle) : 'No translated source available. WEBGL_debug_shaders not implemented';
    } // PRIVATE METHODS

  }, {
    key: "_compile",
    value: function _compile() {
      this.gl.shaderSource(this.handle, this.source);
      this.gl.compileShader(this.handle); // TODO - For performance reasons, avoid checking shader compilation errors on production?
      // TODO - Load log even when no error reported, to catch warnings?
      // https://gamedev.stackexchange.com/questions/30429/how-to-detect-glsl-warnings

      var compileStatus = this.getParameter(GL_COMPILE_STATUS);

      if (!compileStatus) {
        var infoLog = this.gl.getShaderInfoLog(this.handle);

        var _parseGLSLCompilerErr = (0, _webglUtils.parseGLSLCompilerError)(infoLog, this.source, this.shaderType),
            shaderName = _parseGLSLCompilerErr.shaderName,
            errors = _parseGLSLCompilerErr.errors,
            warnings = _parseGLSLCompilerErr.warnings;

        _utils.log.error("GLSL compilation errors in ".concat(shaderName, "\n").concat(errors))();

        _utils.log.warn("GLSL compilation warnings in ".concat(shaderName, "\n").concat(warnings))();

        throw new Error("GLSL compilation errors in ".concat(shaderName));
      }
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteShader(this.handle);
    }
  }, {
    key: "_getOptsFromHandle",
    value: function _getOptsFromHandle() {
      return {
        type: this.getParameter(GL_SHADER_TYPE),
        source: this.getSource()
      };
    }
  }]);

  return Shader;
}(_resource.default);

exports.Shader = Shader;

var VertexShader =
/*#__PURE__*/
function (_Shader) {
  _inherits(VertexShader, _Shader);

  function VertexShader(gl, source) {
    _classCallCheck(this, VertexShader);

    return _possibleConstructorReturn(this, (VertexShader.__proto__ || Object.getPrototypeOf(VertexShader)).call(this, gl, source, GL_VERTEX_SHADER));
  } // PRIVATE METHODS


  _createClass(VertexShader, [{
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createShader(GL_VERTEX_SHADER);
    }
  }]);

  return VertexShader;
}(Shader);

exports.VertexShader = VertexShader;

var FragmentShader =
/*#__PURE__*/
function (_Shader2) {
  _inherits(FragmentShader, _Shader2);

  function FragmentShader(gl, source) {
    _classCallCheck(this, FragmentShader);

    return _possibleConstructorReturn(this, (FragmentShader.__proto__ || Object.getPrototypeOf(FragmentShader)).call(this, gl, source, GL_FRAGMENT_SHADER));
  } // PRIVATE METHODS


  _createClass(FragmentShader, [{
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createShader(GL_FRAGMENT_SHADER);
    }
  }]);

  return FragmentShader;
}(Shader);

exports.FragmentShader = FragmentShader;
//# sourceMappingURL=shader.js.map